/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocDisplayRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CouponInfoType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.RemarkType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TicketDocument;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.UnstructuredFareCalcType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AirDocDisplayRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        AirDocDisplayRS response = (AirDocDisplayRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        Product product = (Product)ctx.getObject((Enum)IBusGdsContextKeys.PRODUCT);
        Collection baseProducts = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        List products = product == null ? (Collection)baseProducts.stream().map(baseProduct -> (Product)baseProduct).collect(Collectors.toList()) : GDSHelper.collectProductsByTravellerGdsId((Collection)baseProducts, (String)product.getTravellerGdsId());
        block0: for (Product prod : products) {
            String ptc = S7NDCHelper.getS7NDCNativeCode(prod.getPassengerType());
            for (AirDocDisplayRS.TicketDocInfos.TicketDocInfo ticketDocInfo : response.getTicketDocInfos().getTicketDocInfoList()) {
                if (!this.checkNames(ticketDocInfo.getTraveler().getSurnameString(), prod.getTraveller().getPassport().getLastName(), (DictionaryReference<PassengerType>)prod.getPassengerType()) || !this.checkNames(ticketDocInfo.getTraveler().getGivenString(), prod.getTraveller().getPassport().getFirstName(), (DictionaryReference<PassengerType>)prod.getPassengerType()) || !ticketDocInfo.getPassengerSpecificData().equalsIgnoreCase(prod.getTraveller().getPassport().getNumber()) || !ticketDocInfo.getTraveler().getPTC().equalsIgnoreCase(ptc)) continue;
                TicketDocument ticketDocument = this.getTicketDocument(ticketDocInfo, prod);
                if (ticketDocument == null) {
                    throw Xeption.forDeveloper((String)"can't find TicketDocument for product with uid {0}", (Object[])new Object[]{prod.getUid()});
                }
                if (ticketDocInfo.getTicketDocumentList() != null && ticketDocInfo.getTicketDocumentList().size() > 1) {
                    int count = (int)ticketDocInfo.getTicketDocumentList().stream().filter(ticketDoc -> ticketDoc.getType().getCode().equals("702")).count();
                    prod.setConjCount(count - 1);
                }
                prod.setSystemNumber(S7NDCHelper.extractProductSystemNumber(ticketDocument));
                prod.setEndorsement(AirDocDisplayRSParser.buildEndorsement(ticketDocInfo));
                if (CollectionUtil.isNotEmpty((Collection)ticketDocInfo.getFareInfo().getUnstructuredFareCalcInfoList())) {
                    prod.setFareCalculationData(((UnstructuredFareCalcType)ticketDocInfo.getFareInfo().getUnstructuredFareCalcInfoList().get(0)).getInfo());
                }
                Iterator segmentIterator = AirProductHelper.getSegments((Collection)prod.getSegmentTariffs()).iterator();
                for (CouponInfoType couponInfo : ticketDocument.getCouponInfoList()) {
                    Segment seg = (Segment)segmentIterator.next();
                    seg.setNotValidBefore(MiscUtil.clearTime((Date)new Date()));
                    if (couponInfo.getCouponValid() == null) continue;
                    seg.setNotValidAfter((Date)couponInfo.getCouponValid().getEffectiveDatePeriod().getExpiration());
                }
                continue block0;
            }
            throw Xeption.forDeveloper((String)"ticketDocInfo not found {0} {1} {2} {3}", (Object[])new Object[]{prod.getTraveller().getPassport().getLastName(), prod.getTraveller().getPassport().getFirstName(), prod.getTraveller().getPassport().getNumber(), ptc});
        }
    }

    private boolean checkNames(String ticketDocName, String passportName, DictionaryReference<PassengerType> passengerType) {
        boolean isAdult = DictHelper.isAdultPassengerTypeCategory(passengerType);
        boolean isInfant = DictHelper.isInfantsPassengerType(passengerType);
        if ((isAdult || isInfant) && ticketDocName.length() == 1) {
            return ticketDocName.toLowerCase().charAt(0) == passportName.toLowerCase().charAt(0);
        }
        return ticketDocName.equalsIgnoreCase(passportName);
    }

    private TicketDocument getTicketDocument(AirDocDisplayRS.TicketDocInfos.TicketDocInfo ticketDocInfo, Product prod) {
        Predicate<TicketDocument> filterPredicate = td -> S7NDCHelper.getGdsTicketDocumentType(prod.getProductCategory()).equals(td.getType().getCode());
        switch (prod.getProductCategory()) {
            case AIR: {
                break;
            }
            case MCO: {
                filterPredicate = filterPredicate.and(td -> AirDocDisplayRSParser.isTicketDocumentOfMcoProduct(td, prod));
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)"unsupported product category : {0}", (Object[])new Object[]{prod.getProductCategory()});
            }
        }
        return ticketDocInfo.getTicketDocumentList().stream().filter(filterPredicate).findFirst().orElse(null);
    }

    private static boolean isTicketDocumentOfMcoProduct(TicketDocument td, Product prod) {
        List segments = AirProductHelper.getSegments((Collection)prod.getSegmentTariffs());
        if (td.getCouponInfoList().size() != segments.size()) {
            return false;
        }
        for (Segment segment : segments) {
            boolean couponExists = td.getCouponInfoList().stream().anyMatch(coupon -> AirDocDisplayRSParser.isMcoSegmentCoupon(coupon, segment, prod));
            if (couponExists) continue;
            return false;
        }
        return true;
    }

    private static boolean isMcoSegmentCoupon(CouponInfoType coupon, Segment seg, Product prod) {
        if (coupon.getReasonForIssuance() == null) {
            return false;
        }
        if (!prod.getGdsId().equals(coupon.getReasonForIssuance().getCode())) {
            return false;
        }
        if (!MiscUtil.equals((Object)S7NDCHelper.convertToDate(coupon.getDateOfService()), (Object)MiscUtil.clearTime((Date)seg.getStartDate()))) {
            return false;
        }
        if (coupon.getPresentInfo() == null) {
            return false;
        }
        if (!MiscUtil.equals((Object)coupon.getPresentInfo().getAt(), (Object)S7NDCHelper.getIataNativeCode(seg.getDepartureLocation()))) {
            return false;
        }
        return MiscUtil.equals((Object)coupon.getPresentInfo().getTo(), (Object)S7NDCHelper.getIataNativeCode(seg.getArriveLocation()));
    }

    private static String buildEndorsement(AirDocDisplayRS.TicketDocInfos.TicketDocInfo ticketDocInfo) {
        StringBuilder sb = new StringBuilder();
        if (ticketDocInfo.getCommission() != null && ticketDocInfo.getCommission().getRemarks() != null && ticketDocInfo.getCommission().getRemarks().getRemarkList() != null) {
            List remarkList = ticketDocInfo.getCommission().getRemarks().getRemarkList();
            for (int i = 0; i < 2; ++i) {
                RemarkType.Remark remark = (RemarkType.Remark)remarkList.get(i);
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(remark.getString());
            }
        } else {
            sb.append("NON-ENDORSABLE INCL VAT 0.00 RUB");
        }
        if (sb.length() > 0) {
            sb.append(' ');
        }
        sb.append(ticketDocInfo.getPassengerSpecificData());
        return sb.toString();
    }
}

