/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AcceptedPaymentFormType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocIssueRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ArrivalCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BagAllowanceDescType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BookingReferenceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CodesetType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CurrencyAmountOptType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListObjAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DepartureCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Description;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DescriptionType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Descriptions;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareComponentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareList;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FarePriceDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfBagAllowanceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfOfferInstructionsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ObjectKeyMetaAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Other;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.RemarkType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Remarks;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TicketDocQuantity;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerInfo;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class AirDocIssueRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product product = (Product)ctx.getObject((Enum)IBusGdsContextKeys.PRODUCT);
        List baseProducts = (List)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        boolean withEmd = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_EMD_CASE)));
        List<Product> mcoProducts = product == null ? Collections.emptyList() : GDSHelper.collectProductsByTravellerGdsId((Collection)baseProducts, (String)product.getTravellerGdsId()).stream().filter(p -> p.getProductCategory() == ProductCategory.MCO).sorted(Comparator.comparing(Product::getGdsId)).collect(Collectors.toList());
        List<Product> airProducts = product == null ? Collections.emptyList() : GDSHelper.collectProductsByTravellerGdsId((Collection)baseProducts, (String)product.getTravellerGdsId()).stream().filter(p -> p.getProductCategory() == ProductCategory.AIR).sorted(Comparator.comparing(Product::getGdsId)).collect(Collectors.toList());
        AirDocIssueRQ airDocIssueRQ = new AirDocIssueRQ();
        TicketDocQuantity queryTicketDocQuantity = new TicketDocQuantity();
        queryTicketDocQuantity.setTicketDocQuantity(BigInteger.ONE);
        airDocIssueRQ.setQueryTicketDocQuantity(queryTicketDocQuantity);
        AirDocIssueRQ.TicketDocInfo ticketDocInfo = new AirDocIssueRQ.TicketDocInfo();
        ticketDocInfo.setTravelerInfo(this.buildTravelerInfo(product));
        BookingReferenceType bookingReference = S7NDCHelper.buildGdsBookingReference(reservation);
        this.updateBookingReference(bookingReference, product, withEmd);
        ticketDocInfo.setBookingReference(bookingReference);
        AirDocIssueRQ.TicketDocInfo.Payments payments = new AirDocIssueRQ.TicketDocInfo.Payments();
        payments.getPaymentList().add(this.buildPayment(reservation, withEmd, false, Collections.singletonList(product)));
        AcceptedPaymentFormType emdPayment = this.buildPayment(reservation, withEmd, true, mcoProducts);
        if (emdPayment != null) {
            payments.getPaymentList().add(emdPayment);
        }
        ticketDocInfo.setPayments(payments);
        airDocIssueRQ.getTicketDocInfoList().add(ticketDocInfo);
        if (withEmd) {
            this.setQueryDataLists(airDocIssueRQ, mcoProducts, airProducts);
        }
        if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
            Pair<String> accountCodeParts = S7NDCHelper.getAccountCodeParts(reservation.getAccountCode());
            DataListType dataLists = airDocIssueRQ.getQueryDataLists();
            if (dataLists == null) {
                dataLists = new DataListType();
                airDocIssueRQ.setQueryDataLists(dataLists);
            }
            ListOfOfferInstructionsType instructionsList = new ListOfOfferInstructionsType();
            instructionsList.getInstructionList().add(S7NDCHelper.buildAccountCodeInstruction(accountCodeParts));
            dataLists.setInstructionsList(instructionsList);
        }
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)airDocIssueRQ);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"DemandTickets");
    }

    private void updateBookingReference(BookingReferenceType bookingReference, Product product, boolean withType) {
        if (product != null) {
            bookingReference.setObjectKeyMetaAttrGroup(new ObjectKeyMetaAttrGroup());
            bookingReference.getObjectKeyMetaAttrGroup().setObjectKey(product.getTravellerGdsId().replaceFirst("SH", "RPH"));
        }
        if (withType) {
            bookingReference.setType(new CodesetType());
            bookingReference.getType().setCode("14");
        }
    }

    private TravelerInfo buildTravelerInfo(Product product) {
        TravelerInfo result = new TravelerInfo();
        if (product == null) {
            result.setSurnameString("ANY");
            result.setGivenString("ANY");
            return result;
        }
        Passport passport = product.getTraveller().getPassport();
        result.setSurnameString(passport.getLastName());
        result.setGivenString(passport.getFirstName());
        result.setPTC(S7NDCHelper.getS7NDCNativeCode(product.getPassengerType()));
        return result;
    }

    private AcceptedPaymentFormType buildPayment(Reservation reservation, boolean withEmd, boolean isEmd, List<Product> products) {
        if (products.isEmpty()) {
            return null;
        }
        AcceptedPaymentFormType payment = new AcceptedPaymentFormType();
        ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup = new ObjectKeyMetaAttrGroup();
        objectKeyMetaAttrGroup.setObjectKey(isEmd ? "EMD" : "ETK");
        payment.setObjectKeyMetaAttrGroup(objectKeyMetaAttrGroup);
        CodesetType type = new CodesetType();
        type.setCode("MS");
        payment.setType(type);
        if (withEmd) {
            Product firstProduct = products.get(0);
            BigDecimal amount = products.stream().map(AirProductHelper::calculateTotalEquivalentFare).reduce(BigDecimal.ZERO, BigDecimal::add);
            CurrencyAmountOptType currencyAmount = new CurrencyAmountOptType();
            currencyAmount.setCode(firstProduct.getGdsCurrency());
            currencyAmount.setDecimal(amount);
            payment.setAmount(currencyAmount);
        }
        Other other = new Other();
        Remarks remarks = new Remarks();
        RemarkType.Remark remark = new RemarkType.Remark();
        if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
            String[] accountCodeParts = reservation.getAccountCode().split("/");
            remark.setString("*".concat(accountCodeParts[0]));
        } else {
            remark.setString("*A*TEXT");
        }
        remarks.getRemarkList().add(remark);
        other.setRemarks(remarks);
        payment.setOther(other);
        return payment;
    }

    private void setQueryDataLists(AirDocIssueRQ airDocIssueRQ, List<Product> mcoProducts, List<Product> airProducts) {
        if (mcoProducts.isEmpty()) {
            return;
        }
        DataListType dataLists = new DataListType();
        dataLists.setCheckedBagAllowanceList(new ListOfBagAllowanceType());
        dataLists.setFareList(new FareList());
        dataLists.setFlightSegmentList(new DataListType.FlightSegmentList());
        dataLists.setOriginDestinationList(new DataListType.OriginDestinationList());
        HashMap<String, ListOfFlightSegmentType> segmentsMap = new HashMap<String, ListOfFlightSegmentType>();
        airProducts.stream().flatMap(pr -> AirProductHelper.getSegments((Collection)pr.getSegmentTariffs()).stream()).forEach(seg -> {
            if (!segmentsMap.containsKey(seg.getGdsId())) {
                ListOfFlightSegmentType fs = this.buildFlightSegment((Segment)seg);
                dataLists.getFlightSegmentList().getFlightSegmentList().add(fs);
                segmentsMap.put(seg.getGdsId(), fs);
            }
        });
        List segs = AirProductHelper.getSegments((Collection)airProducts.get(0).getSegmentTariffs());
        ArrayList legs = new ArrayList();
        ArrayList<Object> curLeg = null;
        for (Object seg2 : segs) {
            if (curLeg == null || seg2.isStarting()) {
                curLeg = new ArrayList<Object>();
                legs.add(curLeg);
            }
            curLeg.add(seg2);
        }
        int odIndex = 1;
        for (List list : legs) {
            OriginDestination origDest = this.buildOriginDestination(list, odIndex++, segmentsMap);
            dataLists.getOriginDestinationList().getOriginDestinationList().add(origDest);
        }
        int ind = 1;
        for (Product mcoProduct : mcoProducts) {
            List segments = AirProductHelper.getSegments((Collection)mcoProduct.getSegmentTariffs());
            OriginDestination originDestination = dataLists.getOriginDestinationList().getOriginDestinationList().stream().filter(od -> segments.stream().allMatch(s -> od.getFlightReferences().getString().contains(s.getGdsId()))).findFirst().get();
            FareList.FareGroup fg = this.buildFareGroup(mcoProduct, originDestination.getOriginDestinationKey(), ind);
            ListOfBagAllowanceType.CheckedBagAllowance bag = this.buildCheckedBagAllowance(mcoProduct, ind);
            dataLists.getCheckedBagAllowanceList().getCheckedBagAllowanceList().add(bag);
            dataLists.getFareList().getFareGroupList().add(fg);
            ++ind;
        }
        airDocIssueRQ.setQueryDataLists(dataLists);
    }

    private ListOfFlightSegmentType buildFlightSegment(Segment seg) {
        ListOfFlightSegmentType result = new ListOfFlightSegmentType();
        result.setSegmentKey(seg.getGdsId());
        result.setDeparture(S7NDCHelper.buildFlightDepartureType((DictionaryReference<GeoLocation>)seg.getDepartureLocation(), seg.getStartDate()));
        result.setArrival(S7NDCHelper.buildFlightArrivalType((DictionaryReference<GeoLocation>)seg.getArriveLocation(), seg.getEndDate()));
        result.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType((DictionaryReference<Airline>)seg.getAirline(), seg.getFlightNo()));
        result.setOperatingCarrier(S7NDCHelper.buildOperatingCarrier(seg));
        return result;
    }

    private OriginDestination buildOriginDestination(List<Segment> segments, int odIndex, Map<String, ListOfFlightSegmentType> segmentsMap) {
        Pair<String> odCodes = S7NDCHelper.getMcoOriginDestinationCodes(segments);
        String originDestinationKey = "OD" + odIndex;
        OriginDestination result = new OriginDestination();
        result.setOriginDestinationKey(originDestinationKey);
        result.setDepartureCode(new DepartureCode());
        result.getDepartureCode().setString((String)odCodes.getFirst());
        result.setArrivalCode(new ArrivalCode());
        result.getArrivalCode().setString((String)odCodes.getLast());
        String segRefs = segments.stream().map(seg -> (ListOfFlightSegmentType)segmentsMap.get(seg.getGdsId())).peek(fs -> fs.setRefs(originDestinationKey)).map(ListOfFlightSegmentType::getSegmentKey).collect(Collectors.joining(" "));
        result.setFlightReferences(new FlightReferences());
        result.getFlightReferences().setString(segRefs);
        return result;
    }

    private FareList.FareGroup buildFareGroup(Product mcoProduct, String originDestinationKey, int ind) {
        FareList.FareGroup result = new FareList.FareGroup();
        result.setDataListObjAttrGroup(new DataListObjAttrGroup());
        result.getDataListObjAttrGroup().setRefs("EMD");
        result.getDataListObjAttrGroup().setListKey("FG" + ind);
        result.setFareBasisCodeCode("ANY");
        result.setFareFareCode(new FareCode());
        result.getFareFareCode().setCode("ANY");
        result.setFareFareDetail(new FareDetailType());
        FareComponentType fareComponent = new FareComponentType();
        fareComponent.setObjectKeyMetaAttrGroup(new ObjectKeyMetaAttrGroup());
        fareComponent.getObjectKeyMetaAttrGroup().setObjectKey(this.getFareComponentKey(ind));
        fareComponent.getObjectKeyMetaAttrGroup().setRefs(originDestinationKey);
        fareComponent.setPriceBreakdown(new FarePriceDetailType());
        CurrencyAmountOptType baseAmount = new CurrencyAmountOptType();
        baseAmount.setCode(mcoProduct.getGdsCurrency());
        baseAmount.setDecimal(AirProductHelper.getEquivalentFare((Product)mcoProduct));
        fareComponent.getPriceBreakdown().setBaseAmount(baseAmount);
        result.getFareFareDetail().getFareComponentList().add(fareComponent);
        return result;
    }

    private String getFareComponentKey(int ind) {
        return "FC" + ind;
    }

    private ListOfBagAllowanceType.CheckedBagAllowance buildCheckedBagAllowance(Product mcoProduct, int ind) {
        ListOfBagAllowanceType.CheckedBagAllowance result = new ListOfBagAllowanceType.CheckedBagAllowance();
        result.setDataListObjAttrGroup(new DataListObjAttrGroup());
        result.getDataListObjAttrGroup().setListKey("BG" + ind);
        result.getDataListObjAttrGroup().setRefs(this.getFareComponentKey(ind));
        BagAllowanceDescType allowanceDesc = new BagAllowanceDescType();
        allowanceDesc.setApplicableParty("Traveller");
        allowanceDesc.setDescriptions(new Descriptions());
        Description desc = new Description();
        desc.setText(new DescriptionType.Text());
        desc.getText().setString(mcoProduct.getGdsId());
        allowanceDesc.getDescriptions().getDescriptionList().add(desc);
        result.setAllowanceDescription(allowanceDesc);
        return result;
    }
}

