
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Add"/>
 *     &lt;xs:enumeration value="Delete"/>
 *     &lt;xs:enumeration value="Update"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ActionContentType implements Serializable {
    ADD("Add"), DELETE("Delete"), UPDATE("Update");
    private final String value;

    private ActionContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ActionContentType convert(String value) {
        for (ActionContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
