
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AggregatorType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AggregatorID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AggregatorType implements Serializable
{
    private String aggregatorID;
    private List<String> contactInfoRefIDList = new ArrayList<String>();
    private String name;

    /** 
     * Get the 'AggregatorID' element value. Identifier of the aggregator organization.
     * 
     * @return value
     */
    public String getAggregatorID() {
        return aggregatorID;
    }

    /** 
     * Set the 'AggregatorID' element value. Identifier of the aggregator organization.
     * 
     * @param aggregatorID
     */
    public void setAggregatorID(String aggregatorID) {
        this.aggregatorID = aggregatorID;
    }

    /** 
     * Get the list of 'ContactInfoRefID' element items. Reference to a ContactInfoID
     * 
     * @return list
     */
    public List<String> getContactInfoRefIDList() {
        return contactInfoRefIDList;
    }

    /** 
     * Set the list of 'ContactInfoRefID' element items. Reference to a ContactInfoID
     * 
     * @param list
     */
    public void setContactInfoRefIDList(List<String> list) {
        contactInfoRefIDList = list;
    }

    /** 
     * Get the 'Name' element value. Aggregator Name.  Example: Farelogix.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Aggregator Name.  Example: Farelogix.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
