
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * A measurable extent of a particular bag, such as length, or height.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDimensionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:LengthMeasureType" name="HeightMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LengthMeasureType" name="LengthMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LengthMeasureType" name="WidthMeasure" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BagDimensionType implements Serializable
{
    private LengthMeasureType heightMeasure;
    private LengthMeasureType lengthMeasure;
    private LengthMeasureType widthMeasure;

    /** 
     * Get the 'HeightMeasure' element value. A measurement of someone or something from head to foot or from base to top. Measure. Unit. Code must be CMT (centimeters).
     * 
     * @return value
     */
    public LengthMeasureType getHeightMeasure() {
        return heightMeasure;
    }

    /** 
     * Set the 'HeightMeasure' element value. A measurement of someone or something from head to foot or from base to top. Measure. Unit. Code must be CMT (centimeters).
     * 
     * @param heightMeasure
     */
    public void setHeightMeasure(LengthMeasureType heightMeasure) {
        this.heightMeasure = heightMeasure;
    }

    /** 
     * Get the 'LengthMeasure' element value. A measurement or extent of something from end to end; the greater of two or the greatest of three dimensions of an object. Measure. Unit. Code must be CMT (centimeters).
     * 
     * @return value
     */
    public LengthMeasureType getLengthMeasure() {
        return lengthMeasure;
    }

    /** 
     * Set the 'LengthMeasure' element value. A measurement or extent of something from end to end; the greater of two or the greatest of three dimensions of an object. Measure. Unit. Code must be CMT (centimeters).
     * 
     * @param lengthMeasure
     */
    public void setLengthMeasure(LengthMeasureType lengthMeasure) {
        this.lengthMeasure = lengthMeasure;
    }

    /** 
     * Get the 'WidthMeasure' element value. A measurement or extent of the bag from side to side; the lesser of two or the least of three dimensions of the bag.  Unit must be CMT (centimeters).
     * 
     * @return value
     */
    public LengthMeasureType getWidthMeasure() {
        return widthMeasure;
    }

    /** 
     * Set the 'WidthMeasure' element value. A measurement or extent of the bag from side to side; the lesser of two or the least of three dimensions of the bag.  Unit must be CMT (centimeters).
     * 
     * @param widthMeasure
     */
    public void setWidthMeasure(LengthMeasureType widthMeasure) {
        this.widthMeasure = widthMeasure;
    }
}
