
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * A small piece of paper, fabric, plastic or similar material attached to an bag and giving information about it.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagTagType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BagTagID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="IssuingCarrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TagExpediteInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TagFallbackInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TagInterlineInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BagTagType implements Serializable
{
    private String bagTagID;
    private CarrierType issuingCarrier;
    private Boolean tagExpediteInd;
    private Boolean tagFallbackInd;
    private Boolean tagInterlineInd;

    /** 
     * Get the 'BagTagID' element value. The identifier of bag tag.
     * 
     * @return value
     */
    public String getBagTagID() {
        return bagTagID;
    }

    /** 
     * Set the 'BagTagID' element value. The identifier of bag tag.
     * 
     * @param bagTagID
     */
    public void setBagTagID(String bagTagID) {
        this.bagTagID = bagTagID;
    }

    /** 
     * Get the 'IssuingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getIssuingCarrier() {
        return issuingCarrier;
    }

    /** 
     * Set the 'IssuingCarrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param issuingCarrier
     */
    public void setIssuingCarrier(CarrierType issuingCarrier) {
        this.issuingCarrier = issuingCarrier;
    }

    /** 
     * Get the 'TagExpediteInd' element value. The indicator of whether this is a expedite tag.
     * 
     * @return value
     */
    public Boolean getTagExpediteInd() {
        return tagExpediteInd;
    }

    /** 
     * Set the 'TagExpediteInd' element value. The indicator of whether this is a expedite tag.
     * 
     * @param tagExpediteInd
     */
    public void setTagExpediteInd(Boolean tagExpediteInd) {
        this.tagExpediteInd = tagExpediteInd;
    }

    /** 
     * Get the 'TagFallbackInd' element value. The indicator of whether this is a fallback tag.
     * 
     * @return value
     */
    public Boolean getTagFallbackInd() {
        return tagFallbackInd;
    }

    /** 
     * Set the 'TagFallbackInd' element value. The indicator of whether this is a fallback tag.
     * 
     * @param tagFallbackInd
     */
    public void setTagFallbackInd(Boolean tagFallbackInd) {
        this.tagFallbackInd = tagFallbackInd;
    }

    /** 
     * Get the 'TagInterlineInd' element value. The indicator of whether this is a interline tag.
     * 
     * @return value
     */
    public Boolean getTagInterlineInd() {
        return tagInterlineInd;
    }

    /** 
     * Set the 'TagInterlineInd' element value. The indicator of whether this is a interline tag.
     * 
     * @param tagInterlineInd
     */
    public void setTagInterlineInd(Boolean tagInterlineInd) {
        this.tagInterlineInd = tagInterlineInd;
    }
}
