
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Carrier imposed fee detail, typically related to booking, ticketing, or servicing.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierFeeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AppCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareComponentType" name="FareComponent" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OriginDestType" name="OriginDest" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentMethodType" name="PaymentMethod" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReportingCodeText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierFeeType implements Serializable
{
    private AmountType amount;
    private String appCode;
    private CarrierType carrier;
    private List<FareComponentType> fareComponentList = new ArrayList<FareComponentType>();
    private OriginDestType originDest;
    private PaymentMethodType paymentMethod;
    private String reportingCodeText;
    private TaxSummaryType taxSummary;
    private String typeCode;

    /** 
     * Get the 'Amount' element value. Fee amount and currency code.
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Fee amount and currency code.
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'AppCode' element value. Code used to specify if the fee is non-interlineable, non-refundable, or non-commissionable.
     * 
     * @return value
     */
    public String getAppCode() {
        return appCode;
    }

    /** 
     * Set the 'AppCode' element value. Code used to specify if the fee is non-interlineable, non-refundable, or non-commissionable.
     * 
     * @param appCode
     */
    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the list of 'FareComponent' element items. A portion of an itinerary between two consecutive fare construction points.  If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * 
     * @return list
     */
    public List<FareComponentType> getFareComponentList() {
        return fareComponentList;
    }

    /** 
     * Set the list of 'FareComponent' element items. A portion of an itinerary between two consecutive fare construction points.  If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * 
     * @param list
     */
    public void setFareComponentList(List<FareComponentType> list) {
        fareComponentList = list;
    }

    /** 
     * Get the 'OriginDest' element value. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @return value
     */
    public OriginDestType getOriginDest() {
        return originDest;
    }

    /** 
     * Set the 'OriginDest' element value. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @param originDest
     */
    public void setOriginDest(OriginDestType originDest) {
        this.originDest = originDest;
    }

    /** 
     * Get the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return value
     */
    public PaymentMethodType getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(PaymentMethodType paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'ReportingCodeText' element value.
     * 
     * @return value
     */
    public String getReportingCodeText() {
        return reportingCodeText;
    }

    /** 
     * Set the 'ReportingCodeText' element value.
     * 
     * @param reportingCodeText
     */
    public void setReportingCodeText(String reportingCodeText) {
        this.reportingCodeText = reportingCodeText;
    }

    /** 
     * Get the 'TaxSummary' element value. Tax summary information.
     * 
     * @return value
     */
    public TaxSummaryType getTaxSummary() {
        return taxSummary;
    }

    /** 
     * Set the 'TaxSummary' element value. Tax summary information.
     * 
     * @param taxSummary
     */
    public void setTaxSummary(TaxSummaryType taxSummary) {
        this.taxSummary = taxSummary;
    }

    /** 
     * Get the 'TypeCode' element value. The type of carrier fee related to booking, ticketing, or servicing as defined by PADIS 9750 (option).
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. The type of carrier fee related to booking, ticketing, or servicing as defined by PADIS 9750 (option).
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
}
