
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CommissionCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PercentType" name="Percentage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RemarkText" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:boolean" name="TaxableInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CommissionType implements Serializable
{
    private AmountType amount;
    private String commissionCode;
    private PercentType percentage;
    private List<String> remarkTextList = new ArrayList<String>();
    private Boolean taxableInd;

    /** 
     * Get the 'Amount' element value. Commission amount and currency code. Example: 20 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Commission amount and currency code. Example: 20 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'CommissionCode' element value. Commission code.  Example: 1000, BFST
     * 
     * @return value
     */
    public String getCommissionCode() {
        return commissionCode;
    }

    /** 
     * Set the 'CommissionCode' element value. Commission code.  Example: 1000, BFST
     * 
     * @param commissionCode
     */
    public void setCommissionCode(String commissionCode) {
        this.commissionCode = commissionCode;
    }

    /** 
     * Get the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @return value
     */
    public PercentType getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Commission percentage. Example: 20
     * 
     * @param percentage
     */
    public void setPercentage(PercentType percentage) {
        this.percentage = percentage;
    }

    /** 
     * Get the list of 'RemarkText' element items. Additional remarks to describe the commission.
     * 
     * @return list
     */
    public List<String> getRemarkTextList() {
        return remarkTextList;
    }

    /** 
     * Set the list of 'RemarkText' element items. Additional remarks to describe the commission.
     * 
     * @param list
     */
    public void setRemarkTextList(List<String> list) {
        remarkTextList = list;
    }

    /** 
     * Get the 'TaxableInd' element value. When TRUE, the commission amount specified is subject to Tax/VAT.
     * 
     * @return value
     */
    public Boolean getTaxableInd() {
        return taxableInd;
    }

    /** 
     * Set the 'TaxableInd' element value. When TRUE, the commission amount specified is subject to Tax/VAT.
     * 
     * @param taxableInd
     */
    public void setTaxableInd(Boolean taxableInd) {
        this.taxableInd = taxableInd;
    }
}
