
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Indicates the owner of specific content found in a message, located by XPATH.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContentSourceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ContentOwnerType" name="ContentOwner" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="NodePathText" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContentSourceType implements Serializable
{
    private ContentOwnerType contentOwner;
    private String nodePathText;

    /** 
     * Get the 'ContentOwner' element value. Airline or Organization from which the associated content originates.
     * 
     * @return value
     */
    public ContentOwnerType getContentOwner() {
        return contentOwner;
    }

    /** 
     * Set the 'ContentOwner' element value. Airline or Organization from which the associated content originates.
     * 
     * @param contentOwner
     */
    public void setContentOwner(ContentOwnerType contentOwner) {
        this.contentOwner = contentOwner;
    }

    /** 
     * Get the 'NodePathText' element value.
     * 
     * @return value
     */
    public String getNodePathText() {
        return nodePathText;
    }

    /** 
     * Set the 'NodePathText' element value.
     * 
     * @param nodePathText
     */
    public void setNodePathText(String nodePathText) {
        this.nodePathText = nodePathText;
    }
}
