
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Latest flight information as it relates to a coupon (e.g. Current, CheckedIn, Flown).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrentCouponFlightInfoType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:PaxSegmentRefType" name="CheckedInAirlineInfo" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxSegmentRefType" name="CurrentAirlineInfo" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxSegmentRefType" name="FlownAirlineInfo" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurrentCouponFlightInfoType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CHECKED_IN_AIRLINE_INFO_CHOICE = 0;
    private static final int CURRENT_AIRLINE_INFO_CHOICE = 1;
    private static final int FLOWN_AIRLINE_INFO_CHOICE = 2;
    private PaxSegmentRefType checkedInAirlineInfo;
    private PaxSegmentRefType currentAirlineInfo;
    private PaxSegmentRefType flownAirlineInfo;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CheckedInAirlineInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCheckedInAirlineInfo() {
        return choiceSelect == CHECKED_IN_AIRLINE_INFO_CHOICE;
    }

    /** 
     * Get the 'CheckedInAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return value
     */
    public PaxSegmentRefType getCheckedInAirlineInfo() {
        return checkedInAirlineInfo;
    }

    /** 
     * Set the 'CheckedInAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param checkedInAirlineInfo
     */
    public void setCheckedInAirlineInfo(PaxSegmentRefType checkedInAirlineInfo) {
        setChoiceSelect(CHECKED_IN_AIRLINE_INFO_CHOICE);
        this.checkedInAirlineInfo = checkedInAirlineInfo;
    }

    /** 
     * Check if CurrentAirlineInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCurrentAirlineInfo() {
        return choiceSelect == CURRENT_AIRLINE_INFO_CHOICE;
    }

    /** 
     * Get the 'CurrentAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return value
     */
    public PaxSegmentRefType getCurrentAirlineInfo() {
        return currentAirlineInfo;
    }

    /** 
     * Set the 'CurrentAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param currentAirlineInfo
     */
    public void setCurrentAirlineInfo(PaxSegmentRefType currentAirlineInfo) {
        setChoiceSelect(CURRENT_AIRLINE_INFO_CHOICE);
        this.currentAirlineInfo = currentAirlineInfo;
    }

    /** 
     * Check if FlownAirlineInfo is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlownAirlineInfo() {
        return choiceSelect == FLOWN_AIRLINE_INFO_CHOICE;
    }

    /** 
     * Get the 'FlownAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return value
     */
    public PaxSegmentRefType getFlownAirlineInfo() {
        return flownAirlineInfo;
    }

    /** 
     * Set the 'FlownAirlineInfo' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param flownAirlineInfo
     */
    public void setFlownAirlineInfo(PaxSegmentRefType flownAirlineInfo) {
        setChoiceSelect(FLOWN_AIRLINE_INFO_CHOICE);
        this.flownAirlineInfo = flownAirlineInfo;
    }
}
