
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * System in which a corporation's travel agency bills employees for their business travel. The employee must then submit an expense accounting and be reimbursed by the corporation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectBillType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrgID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrgName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DirectBillType implements Serializable
{
    private String contactInfoRefID;
    private String orgID;
    private String orgName;

    /** 
     * Get the 'ContactInfoRefID' element value. Reference to a Contact ID within this message.
     * 
     * @return value
     */
    public String getContactInfoRefID() {
        return contactInfoRefID;
    }

    /** 
     * Set the 'ContactInfoRefID' element value. Reference to a Contact ID within this message.
     * 
     * @param contactInfoRefID
     */
    public void setContactInfoRefID(String contactInfoRefID) {
        this.contactInfoRefID = contactInfoRefID;
    }

    /** 
     * Get the 'OrgID' element value. The company ID of the corporation to whom remittance should be directed. Example: IBM
     * 
     * @return value
     */
    public String getOrgID() {
        return orgID;
    }

    /** 
     * Set the 'OrgID' element value. The company ID of the corporation to whom remittance should be directed. Example: IBM
     * 
     * @param orgID
     */
    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    /** 
     * Get the 'OrgName' element value. The company name of the corporation to whom remittance should be directed. Example: IBM
     * 
     * @return value
     */
    public String getOrgName() {
        return orgName;
    }

    /** 
     * Set the 'OrgName' element value. The company name of the corporation to whom remittance should be directed. Example: IBM
     * 
     * @param orgName
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
