
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Contains information related to errors detected during processing of the preceding request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ErrorType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ErrorID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LangCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StatusText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ErrorType implements Serializable
{
    private String code;
    private String descText;
    private String errorID;
    private String langCode;
    private String ownerName;
    private String statusText;
    private String tagText;
    private String typeCode;
    private String URL;

    /** 
     * Get the 'Code' element value. The code corresponding to the processing error as defined by PADIS 9321.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. The code corresponding to the processing error as defined by PADIS 9321.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'DescText' element value. Free text description of the provided error.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Free text description of the provided error.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'ErrorID' element value. Unique identifier for this error instance.
     * 
     * @return value
     */
    public String getErrorID() {
        return errorID;
    }

    /** 
     * Set the 'ErrorID' element value. Unique identifier for this error instance.
     * 
     * @param errorID
     */
    public void setErrorID(String errorID) {
        this.errorID = errorID;
    }

    /** 
     * Get the 'LangCode' element value. Language code associated with the error response.
     * 
     * @return value
     */
    public String getLangCode() {
        return langCode;
    }

    /** 
     * Set the 'LangCode' element value. Language code associated with the error response.
     * 
     * @param langCode
     */
    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    /** 
     * Get the 'OwnerName' element value. The name of the organization owning the error codelist.
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. The name of the organization owning the error codelist.
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the 'StatusText' element value. Document processing status.  Recommended values are NotProcessed, Incomplete, Complete, Unknown.
     * 
     * @return value
     */
    public String getStatusText() {
        return statusText;
    }

    /** 
     * Set the 'StatusText' element value. Document processing status.  Recommended values are NotProcessed, Incomplete, Complete, Unknown.
     * 
     * @param statusText
     */
    public void setStatusText(String statusText) {
        this.statusText = statusText;
    }

    /** 
     * Get the 'TagText' element value. Identifies the tag/XPath which relates to the provided Error.
     * 
     * @return value
     */
    public String getTagText() {
        return tagText;
    }

    /** 
     * Set the 'TagText' element value. Identifies the tag/XPath which relates to the provided Error.
     * 
     * @param tagText
     */
    public void setTagText(String tagText) {
        this.tagText = tagText;
    }

    /** 
     * Get the 'TypeCode' element value. Uses a bilaterally agreed set of values to indicate the error type.  The validating XSD can expect to accept values that it has not been explicitly coded for and process them by using Type = 'unknown'.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Uses a bilaterally agreed set of values to indicate the error type.  The validating XSD can expect to accept values that it has not been explicitly coded for and process them by using Type = 'unknown'.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'URL' element value. Link to an online description of the provided Error.
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Link to an online description of the provided Error.
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }
}
