
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Information related to the calculation of the Fare amount by applying various rules to determine a final fare for an airline ticket.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareCalculationInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AddlInfoText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PricingCodeText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReportingCodeText" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareCalculationInfoType implements Serializable
{
    private String addlInfoText;
    private String pricingCodeText;
    private String reportingCodeText;

    /** 
     * Get the 'AddlInfoText' element value. The fare calculation text required in the fare calculation area of an electronic ticket.
     * 
     * @return value
     */
    public String getAddlInfoText() {
        return addlInfoText;
    }

    /** 
     * Set the 'AddlInfoText' element value. The fare calculation text required in the fare calculation area of an electronic ticket.
     * 
     * @param addlInfoText
     */
    public void setAddlInfoText(String addlInfoText) {
        this.addlInfoText = addlInfoText;
    }

    /** 
     * Get the 'PricingCodeText' element value. Primary identifier reflecting the method of pricing for a transaction.
     * 
     * @return value
     */
    public String getPricingCodeText() {
        return pricingCodeText;
    }

    /** 
     * Set the 'PricingCodeText' element value. Primary identifier reflecting the method of pricing for a transaction.
     * 
     * @param pricingCodeText
     */
    public void setPricingCodeText(String pricingCodeText) {
        this.pricingCodeText = pricingCodeText;
    }

    /** 
     * Get the 'ReportingCodeText' element value. Secondary identifier reflecting the method of pricing for a transaction used in the reporting process.
     * 
     * @return value
     */
    public String getReportingCodeText() {
        return reportingCodeText;
    }

    /** 
     * Set the 'ReportingCodeText' element value. Secondary identifier reflecting the method of pricing for a transaction used in the reporting process.
     * 
     * @param reportingCodeText
     */
    public void setReportingCodeText(String reportingCodeText) {
        this.reportingCodeText = reportingCodeText;
    }
}
