
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareGroupType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FareCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FareGroupID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareGroupType implements Serializable
{
    private String fareCode;
    private List<FareDetailType> fareDetailList = new ArrayList<FareDetailType>();
    private String fareGroupID;

    /** 
     * Get the 'FareCode' element value. Fare Type Code. Examples: 70J, Published Fares 70K, Dynamic Discounted Fares 749, Negotiated Fares 756, One Way Fare 758, Private Fares Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
     * 
     * @return value
     */
    public String getFareCode() {
        return fareCode;
    }

    /** 
     * Set the 'FareCode' element value. Fare Type Code. Examples: 70J, Published Fares 70K, Dynamic Discounted Fares 749, Negotiated Fares 756, One Way Fare 758, Private Fares Encoding Scheme: PADIS codeset element 9910 - Fare Qualifier
     * 
     * @param fareCode
     */
    public void setFareCode(String fareCode) {
        this.fareCode = fareCode;
    }

    /** 
     * Get the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return list
     */
    public List<FareDetailType> getFareDetailList() {
        return fareDetailList;
    }

    /** 
     * Set the list of 'FareDetail' element items. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param list
     */
    public void setFareDetailList(List<FareDetailType> list) {
        fareDetailList = list;
    }

    /** 
     * Get the 'FareGroupID' element value. Unique identifier for this Fare Group
     * 
     * @return value
     */
    public String getFareGroupID() {
        return fareGroupID;
    }

    /** 
     * Set the 'FareGroupID' element value. Unique identifier for this Fare Group
     * 
     * @param fareGroupID
     */
    public void setFareGroupID(String fareGroupID) {
        this.fareGroupID = fareGroupID;
    }
}
