
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Validating carrier-assigned fare rule modification or override information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareWaiverType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FareRuleWaiverCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareWaiverTypeCode" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareWaiverType implements Serializable
{
    private String fareRuleWaiverCode;
    private String fareWaiverTypeCode;

    /** 
     * Get the 'FareRuleWaiverCode' element value. Code assigned by the validating carrier that allows fare rule modification or override.
     * 
     * @return value
     */
    public String getFareRuleWaiverCode() {
        return fareRuleWaiverCode;
    }

    /** 
     * Set the 'FareRuleWaiverCode' element value. Code assigned by the validating carrier that allows fare rule modification or override.
     * 
     * @param fareRuleWaiverCode
     */
    public void setFareRuleWaiverCode(String fareRuleWaiverCode) {
        this.fareRuleWaiverCode = fareRuleWaiverCode;
    }

    /** 
     * Get the 'FareWaiverTypeCode' element value. Waiver type code.  Examples: ExchangeReissued, FareComponent.
     * 
     * @return value
     */
    public String getFareWaiverTypeCode() {
        return fareWaiverTypeCode;
    }

    /** 
     * Set the 'FareWaiverTypeCode' element value. Waiver type code.  Examples: ExchangeReissued, FareComponent.
     * 
     * @param fareWaiverTypeCode
     */
    public void setFareWaiverTypeCode(String fareWaiverTypeCode) {
        this.fareWaiverTypeCode = fareWaiverTypeCode;
    }
}
