
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * This is an early draft of the OrderViewRS message.  There are still several changes to come:
 - Replacing some nested structures with reference by ID.
 - Abbreviation/Acronym application
 - Sequencing of elements to be alphabetical
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderViewRS">
 *   &lt;xs:key name="ContactInfoIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ContactInfoList/k:ContactInfo"/>
 *     &lt;xs:field xpath="k:ContactInfoID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef9">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef10">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef11">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef12">
 *     &lt;xs:selector xpath="./k:PaymentInfo/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef13">
 *     &lt;xs:selector xpath="./k:PaymentInfo/k:PaymentMethod/k:DirectBill/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax"/>
 *     &lt;xs:field xpath="k:PaxID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef">
 *     &lt;xs:selector xpath="./k:PaymentInfo/k:Promotion/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef14">
 *     &lt;xs:selector xpath="./k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef15">
 *     &lt;xs:selector xpath="./k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PenaltyIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PenaltyList/k:Penalty"/>
 *     &lt;xs:field xpath="k:PenaltyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxSegmentIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxSegmentList/k:PaxSegment"/>
 *     &lt;xs:field xpath="k:PaxSegmentID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PriceClassIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PriceClassList/k:PriceClass"/>
 *     &lt;xs:field xpath="k:PriceClassID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxJourneyIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxJourneyList/k:PaxJourney"/>
 *     &lt;xs:field xpath="k:PaxJourneyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:OriginDestList/k:OriginDest/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxJourneyList/k:PaxJourney/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef16">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxList/k:Pax/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="BaggageAllowanceIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:BaggageAllowanceList/k:BaggageAllowance"/>
 *     &lt;xs:field xpath="k:BaggageAllowanceID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="SeatProfileIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:SeatProfileList/k:SeatProfile"/>
 *     &lt;xs:field xpath="k:SeatProfileID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="ServiceDefinitionIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition"/>
 *     &lt;xs:field xpath="k:ServiceDefinitionID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:ServiceBundle/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef17">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:BookingRef/k:BookingEntity/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:Service/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:Service/k:ServiceAssociations/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="DatedOperatingLegIDKey">
 *     &lt;xs:selector xpath="./k:Response/k:DataLists/k:PaxSegmentList/k:PaxSegment/k:DatedOperatingLeg"/>
 *     &lt;xs:field xpath="k:DatedOperatingLegID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:Service/k:ServiceAssociations/k:SelectedSeat/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:Service/k:ServiceAssociations/k:SelectedSeat/k:Seat/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:OrderItem/k:Service/k:ServiceAssociations/k:ServiceDefinitionRef/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef18">
 *     &lt;xs:selector xpath="./k:Response/k:Order/k:PaxGroup/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef19">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:BookingAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef20">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:BookingRef/k:BookingEntity/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:CarrierFee/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:CarrierFee/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:CarrierFee/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:CarrierFee/k:OriginDest/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef21">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:CarrierFee/k:PaymentMethod/k:DirectBill/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:OriginDest/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaymentInfoIDKey">
 *     &lt;xs:selector xpath="./k:PaymentInfo"/>
 *     &lt;xs:field xpath="k:PaymentInfoID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaymentInfoIDKey" name="PaymentInfoIDKeyRef">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:PaymentInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef22">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:BookingRef/k:BookingEntity/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:Service/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:Service/k:ServiceAssociations/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:Service/k:ServiceAssociations/k:SelectedSeat/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:Service/k:ServiceAssociations/k:SelectedSeat/k:Seat/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:OrderItem/k:Service/k:ServiceAssociations/k:ServiceDefinitionRef/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef23">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ReferencedOrder/k:PaxGroup/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef24">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:ServicingAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef10">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:CurrentCouponFlightInfo/k:CheckedInAirlineInfo/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef11">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:CurrentCouponFlightInfo/k:CurrentAirlineInfo/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef12">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:CurrentCouponFlightInfo/k:FlownAirlineInfo/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef9">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:Promotion/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef25">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:Promotion/k:PromotionIssuer/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef26">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:Promotion/k:PromotionIssuer/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef13">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:ResChangeInfo/k:PaxSegment/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef14">
 *     &lt;xs:selector xpath="./k:Response/k:TicketDocInfo/k:Ticket/k:Coupon/k:SoldAirlineInfo/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:choice>
 *         &lt;xs:element type="ns:ErrorType" name="Error" maxOccurs="unbounded"/>
 *         &lt;xs:element type="ns:ResponseType" name="Response"/>
 *       &lt;/xs:choice>
 *       &lt;xs:element name="AugmentationPoint" minOccurs="0">
 *         &lt;!-- Reference to inner class AugmentationPoint -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PartyType" name="Party" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PaymentInfoType" name="PaymentInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderViewRS implements Serializable
{
    private int choiceSelect = -1;
    private static final int ERROR_LIST_CHOICE = 0;
    private static final int RESPONSE_CHOICE = 1;
    private List<ErrorType> errorList = new ArrayList<ErrorType>();
    private ResponseType response;
    private AugmentationPoint augmentationPoint;
    private MessageDocType messageDoc;
    private PartyType party;
    private IATAPayloadStandardAttributesType payloadAttributes;
    private List<PaymentInfoType> paymentInfoList = new ArrayList<PaymentInfoType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ErrorList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifErrorList() {
        return choiceSelect == ERROR_LIST_CHOICE;
    }

    /** 
     * Get the list of 'Error' element items. Error information, including augmentation point.
     * 
     * @return list
     */
    public List<ErrorType> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items. Error information, including augmentation point.
     * 
     * @param list
     */
    public void setErrorList(List<ErrorType> list) {
        setChoiceSelect(ERROR_LIST_CHOICE);
        errorList = list;
    }

    /** 
     * Check if Response is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifResponse() {
        return choiceSelect == RESPONSE_CHOICE;
    }

    /** 
     * Get the 'Response' element value. Message payload information
     * 
     * @return value
     */
    public ResponseType getResponse() {
        return response;
    }

    /** 
     * Set the 'Response' element value. Message payload information
     * 
     * @param response
     */
    public void setResponse(ResponseType response) {
        setChoiceSelect(RESPONSE_CHOICE);
        this.response = response;
    }

    /** 
     * Get the 'AugmentationPoint' element value.
     * 
     * @return value
     */
    public AugmentationPoint getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(AugmentationPoint augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'MessageDoc' element value. Message document information including document name and version number.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. Message document information including document name and version number.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @return value
     */
    public PartyType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @param party
     */
    public void setParty(PartyType party) {
        this.party = party;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }

    /** 
     * Get the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @return list
     */
    public List<PaymentInfoType> getPaymentInfoList() {
        return paymentInfoList;
    }

    /** 
     * Set the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @param list
     */
    public void setPaymentInfoList(List<PaymentInfoType> list) {
        paymentInfoList = list;
    }
    /** 
     * Implementer-Augmented Structure.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMDR_03_1_1A" xmlns:ns1="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:ns2="http://xml.amadeus.com/QUQPCR_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugmentationPoint" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns2:Queue_PlacePNRReply"/>
     *       &lt;xs:element ref="ns:Queue_RemoveItemReply"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AugmentationPoint implements Serializable
    {
        private int augmentationPointSelect = -1;
        private static final int QUEUE_PLACE_PNR_REPLY_CHOICE = 0;
        private static final int QUEUE_REMOVE_ITEM_REPLY_CHOICE = 1;
        private QueuePlacePNRReply queuePlacePNRReply;
        private QueueRemoveItemReply queueRemoveItemReply;

        private void setAugmentationPointSelect(int choice) {
            if (augmentationPointSelect == -1) {
                augmentationPointSelect = choice;
            } else if (augmentationPointSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearAugmentationPointSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearAugmentationPointSelect() {
            augmentationPointSelect = -1;
        }

        /** 
         * Check if QueuePlacePNRReply is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQueuePlacePNRReply() {
            return augmentationPointSelect == QUEUE_PLACE_PNR_REPLY_CHOICE;
        }

        /** 
         * Get the 'Queue_PlacePNRReply' element value.
         * 
         * @return value
         */
        public QueuePlacePNRReply getQueuePlacePNRReply() {
            return queuePlacePNRReply;
        }

        /** 
         * Set the 'Queue_PlacePNRReply' element value.
         * 
         * @param queuePlacePNRReply
         */
        public void setQueuePlacePNRReply(QueuePlacePNRReply queuePlacePNRReply) {
            setAugmentationPointSelect(QUEUE_PLACE_PNR_REPLY_CHOICE);
            this.queuePlacePNRReply = queuePlacePNRReply;
        }

        /** 
         * Check if QueueRemoveItemReply is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQueueRemoveItemReply() {
            return augmentationPointSelect == QUEUE_REMOVE_ITEM_REPLY_CHOICE;
        }

        /** 
         * Get the 'Queue_RemoveItemReply' element value.
         * 
         * @return value
         */
        public QueueRemoveItemReply getQueueRemoveItemReply() {
            return queueRemoveItemReply;
        }

        /** 
         * Set the 'Queue_RemoveItemReply' element value.
         * 
         * @param queueRemoveItemReply
         */
        public void setQueueRemoveItemReply(
                QueueRemoveItemReply queueRemoveItemReply) {
            setAugmentationPointSelect(QUEUE_REMOVE_ITEM_REPLY_CHOICE);
            this.queueRemoveItemReply = queueRemoveItemReply;
        }
    }
}
