
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Electronic documents, images, and other files which accompany and support some information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MediaObjectType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BinaryObjectType" name="BinaryObject" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="FileSizeMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="HeightMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="HintText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MediaID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RenderingInstructionsText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RenderingMethodText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RenderingOutputFormatText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RenderingOverviewText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="WidthMeasure" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MediaObjectType implements Serializable
{
    private BinaryObjectType binaryObject;
    private String descText;
    private MeasureType fileSizeMeasure;
    private MeasureType heightMeasure;
    private String hintText;
    private String mediaID;
    private String renderingInstructionsText;
    private String renderingMethodText;
    private String renderingOutputFormatText;
    private String renderingOverviewText;
    private MeasureType widthMeasure;

    /** 
     * Get the 'BinaryObject' element value. Binary Object Information.  Supplementary attributes include character set code, MIME code, encoding information, file name, format, and URI
     * 
     * @return value
     */
    public BinaryObjectType getBinaryObject() {
        return binaryObject;
    }

    /** 
     * Set the 'BinaryObject' element value. Binary Object Information.  Supplementary attributes include character set code, MIME code, encoding information, file name, format, and URI
     * 
     * @param binaryObject
     */
    public void setBinaryObject(BinaryObjectType binaryObject) {
        this.binaryObject = binaryObject;
    }

    /** 
     * Get the 'DescText' element value. Description of the referenced media.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Description of the referenced media.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'FileSizeMeasure' element value. The size of the Attachment in kilobytes (KB). Example: 60
     * 
     * @return value
     */
    public MeasureType getFileSizeMeasure() {
        return fileSizeMeasure;
    }

    /** 
     * Set the 'FileSizeMeasure' element value. The size of the Attachment in kilobytes (KB). Example: 60
     * 
     * @param fileSizeMeasure
     */
    public void setFileSizeMeasure(MeasureType fileSizeMeasure) {
        this.fileSizeMeasure = fileSizeMeasure;
    }

    /** 
     * Get the 'HeightMeasure' element value. Media (typically Image) height in specified units.
     * 
     * @return value
     */
    public MeasureType getHeightMeasure() {
        return heightMeasure;
    }

    /** 
     * Set the 'HeightMeasure' element value. Media (typically Image) height in specified units.
     * 
     * @param heightMeasure
     */
    public void setHeightMeasure(MeasureType heightMeasure) {
        this.heightMeasure = heightMeasure;
    }

    /** 
     * Get the 'HintText' element value. Media object tip which is typically used in a client GUI (a mouseover tip). Example: Envoy Class Seat
     * 
     * @return value
     */
    public String getHintText() {
        return hintText;
    }

    /** 
     * Set the 'HintText' element value. Media object tip which is typically used in a client GUI (a mouseover tip). Example: Envoy Class Seat
     * 
     * @param hintText
     */
    public void setHintText(String hintText) {
        this.hintText = hintText;
    }

    /** 
     * Get the 'MediaID' element value. Uniquely Identifies a Media file within the context of one message.
     * 
     * @return value
     */
    public String getMediaID() {
        return mediaID;
    }

    /** 
     * Set the 'MediaID' element value. Uniquely Identifies a Media file within the context of one message.
     * 
     * @param mediaID
     */
    public void setMediaID(String mediaID) {
        this.mediaID = mediaID;
    }

    /** 
     * Get the 'RenderingInstructionsText' element value. Rendering Instruction Parameters. Notes: This is typically used for XSLT.
     * 
     * @return value
     */
    public String getRenderingInstructionsText() {
        return renderingInstructionsText;
    }

    /** 
     * Set the 'RenderingInstructionsText' element value. Rendering Instruction Parameters. Notes: This is typically used for XSLT.
     * 
     * @param renderingInstructionsText
     */
    public void setRenderingInstructionsText(String renderingInstructionsText) {
        this.renderingInstructionsText = renderingInstructionsText;
    }

    /** 
     * Get the 'RenderingMethodText' element value. Rendering Method name.  E.g. Narrative, XSLT, etc.
     * 
     * @return value
     */
    public String getRenderingMethodText() {
        return renderingMethodText;
    }

    /** 
     * Set the 'RenderingMethodText' element value. Rendering Method name.  E.g. Narrative, XSLT, etc.
     * 
     * @param renderingMethodText
     */
    public void setRenderingMethodText(String renderingMethodText) {
        this.renderingMethodText = renderingMethodText;
    }

    /** 
     * Get the 'RenderingOutputFormatText' element value. An identifier for a file format or content type of the rendered output.
     * 
     * @return value
     */
    public String getRenderingOutputFormatText() {
        return renderingOutputFormatText;
    }

    /** 
     * Set the 'RenderingOutputFormatText' element value. An identifier for a file format or content type of the rendered output.
     * 
     * @param renderingOutputFormatText
     */
    public void setRenderingOutputFormatText(String renderingOutputFormatText) {
        this.renderingOutputFormatText = renderingOutputFormatText;
    }

    /** 
     * Get the 'RenderingOverviewText' element value. An overview of the rendering method or style.
     * 
     * @return value
     */
    public String getRenderingOverviewText() {
        return renderingOverviewText;
    }

    /** 
     * Set the 'RenderingOverviewText' element value. An overview of the rendering method or style.
     * 
     * @param renderingOverviewText
     */
    public void setRenderingOverviewText(String renderingOverviewText) {
        this.renderingOverviewText = renderingOverviewText;
    }

    /** 
     * Get the 'WidthMeasure' element value. Media (typically Image) width in specified units.
     * 
     * @return value
     */
    public MeasureType getWidthMeasure() {
        return widthMeasure;
    }

    /** 
     * Set the 'WidthMeasure' element value. Media (typically Image) width in specified units.
     * 
     * @param widthMeasure
     */
    public void setWidthMeasure(MeasureType widthMeasure) {
        this.widthMeasure = widthMeasure;
    }
}
