
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Order1Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:OrderItem1Type" name="OrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Order1Type implements Serializable
{
    private List<OrderItem1Type> orderItemList = new ArrayList<OrderItem1Type>();
    private String orderRefID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private String webAddressURI;

    /** 
     * Get the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @return list
     */
    public List<OrderItem1Type> getOrderItemList() {
        return orderItemList;
    }

    /** 
     * Set the list of 'OrderItem' element items. An individually priced item within an Order, made up of one or more Services. May or may not be a selected Offer Item (e.g. non-chargeable Services available on request such as a wheelchair).
     * 
     * @param list
     */
    public void setOrderItemList(List<OrderItem1Type> list) {
        orderItemList = list;
    }

    /** 
     * Get the 'OrderRefID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderRefID() {
        return orderRefID;
    }

    /** 
     * Set the 'OrderRefID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderRefID
     */
    public void setOrderRefID(String orderRefID) {
        this.orderRefID = orderRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
