
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * shows the possible statuses of an Order
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderStatusCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CLOSED"/>
 *     &lt;xs:enumeration value="FROZEN"/>
 *     &lt;xs:enumeration value="OPENED"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OrderStatusCodeContentType implements Serializable {
    /** 
     * Once all Order Items are FULLY PAID and Services are either DELIVERED or REFUNDED or EXPIRED
     */
    CLOSED, /** 
             * emergency lock
             */
    FROZEN, /** 
             * Order was built based on offer information.
             */
    OPENED
}
