
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Minimum/Maximum Option Ordering Quantities.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderingQtyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:QtyType" name="MaximumQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:QtyType" name="MinimumQty" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderingQtyType implements Serializable
{
    private QtyType maximumQty;
    private QtyType minimumQty;

    /** 
     * Get the 'MaximumQty' element value. The MAXIMUM Quantity of the Option that may be ordered. Example: 4
     * 
     * @return value
     */
    public QtyType getMaximumQty() {
        return maximumQty;
    }

    /** 
     * Set the 'MaximumQty' element value. The MAXIMUM Quantity of the Option that may be ordered. Example: 4
     * 
     * @param maximumQty
     */
    public void setMaximumQty(QtyType maximumQty) {
        this.maximumQty = maximumQty;
    }

    /** 
     * Get the 'MinimumQty' element value. The MINIMUM Quantity of the Option that may be ordered. Example: 2
     * 
     * @return value
     */
    public QtyType getMinimumQty() {
        return minimumQty;
    }

    /** 
     * Set the 'MinimumQty' element value. The MINIMUM Quantity of the Option that may be ordered. Example: 2
     * 
     * @param minimumQty
     */
    public void setMinimumQty(QtyType minimumQty) {
        this.minimumQty = minimumQty;
    }
}
