
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * This may be used when an Order has been sub-divided into associated Orders and serves as a reference to the original Order ID.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginalOrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceQuoteType" name="PriceQuote" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginalOrderType implements Serializable
{
    private String orderRefID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private List<PriceQuoteType> priceQuoteList = new ArrayList<PriceQuoteType>();
    private String webAddressURI;

    /** 
     * Get the 'OrderRefID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderRefID() {
        return orderRefID;
    }

    /** 
     * Set the 'OrderRefID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderRefID
     */
    public void setOrderRefID(String orderRefID) {
        this.orderRefID = orderRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the list of 'PriceQuote' element items. Pricing history information for a given Order.
     * 
     * @return list
     */
    public List<PriceQuoteType> getPriceQuoteList() {
        return priceQuoteList;
    }

    /** 
     * Set the list of 'PriceQuote' element items. Pricing history information for a given Order.
     * 
     * @param list
     */
    public void setPriceQuoteList(List<PriceQuoteType> list) {
        priceQuoteList = list;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
