
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to parties relevant to the contents of this message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ParticipantType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AggregatorType" name="Aggregator" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CorporationType" name="Corporation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:EnabledSystemType" name="EnabledSystem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CarrierType" name="MarketingCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CarrierType" name="OperatingCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CarrierType" name="ORA" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CarrierType" name="POA" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:RetailPartnerType" name="RetailPartner" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ParticipantType implements Serializable
{
    private List<AggregatorType> aggregatorList = new ArrayList<AggregatorType>();
    private List<CorporationType> corporationList = new ArrayList<CorporationType>();
    private List<EnabledSystemType> enabledSystemList = new ArrayList<EnabledSystemType>();
    private List<CarrierType> marketingCarrierList = new ArrayList<CarrierType>();
    private List<CarrierType> operatingCarrierList = new ArrayList<CarrierType>();
    private List<CarrierType> ORAList = new ArrayList<CarrierType>();
    private List<CarrierType> POAList = new ArrayList<CarrierType>();
    private List<RetailPartnerType> retailPartnerList = new ArrayList<RetailPartnerType>();
    private List<TravelAgencyType> travelAgencyList = new ArrayList<TravelAgencyType>();

    /** 
     * Get the list of 'Aggregator' element items. An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
     * 
     * @return list
     */
    public List<AggregatorType> getAggregatorList() {
        return aggregatorList;
    }

    /** 
     * Set the list of 'Aggregator' element items. An entity who distributes a Sellerâ€™s shopping request to multiple Airlines and aggregates subsequent responses.
     * 
     * @param list
     */
    public void setAggregatorList(List<AggregatorType> list) {
        aggregatorList = list;
    }

    /** 
     * Get the list of 'Corporation' element items. A company or group of people authorized to act as a single entity (legally a person) and recognized as such in law.
     * 
     * @return list
     */
    public List<CorporationType> getCorporationList() {
        return corporationList;
    }

    /** 
     * Set the list of 'Corporation' element items. A company or group of people authorized to act as a single entity (legally a person) and recognized as such in law.
     * 
     * @param list
     */
    public void setCorporationList(List<CorporationType> list) {
        corporationList = list;
    }

    /** 
     * Get the list of 'EnabledSystem' element items. NDC-enabled system.
     * 
     * @return list
     */
    public List<EnabledSystemType> getEnabledSystemList() {
        return enabledSystemList;
    }

    /** 
     * Set the list of 'EnabledSystem' element items. NDC-enabled system.
     * 
     * @param list
     */
    public void setEnabledSystemList(List<EnabledSystemType> list) {
        enabledSystemList = list;
    }

    /** 
     * Get the list of 'MarketingCarrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return list
     */
    public List<CarrierType> getMarketingCarrierList() {
        return marketingCarrierList;
    }

    /** 
     * Set the list of 'MarketingCarrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param list
     */
    public void setMarketingCarrierList(List<CarrierType> list) {
        marketingCarrierList = list;
    }

    /** 
     * Get the list of 'OperatingCarrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return list
     */
    public List<CarrierType> getOperatingCarrierList() {
        return operatingCarrierList;
    }

    /** 
     * Set the list of 'OperatingCarrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param list
     */
    public void setOperatingCarrierList(List<CarrierType> list) {
        operatingCarrierList = list;
    }

    /** 
     * Get the list of 'ORA' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return list
     */
    public List<CarrierType> getORAList() {
        return ORAList;
    }

    /** 
     * Set the list of 'ORA' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param list
     */
    public void setORAList(List<CarrierType> list) {
        ORAList = list;
    }

    /** 
     * Get the list of 'POA' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return list
     */
    public List<CarrierType> getPOAList() {
        return POAList;
    }

    /** 
     * Set the list of 'POA' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param list
     */
    public void setPOAList(List<CarrierType> list) {
        POAList = list;
    }

    /** 
     * Get the list of 'RetailPartner' element items. A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
     * 
     * @return list
     */
    public List<RetailPartnerType> getRetailPartnerList() {
        return retailPartnerList;
    }

    /** 
     * Set the list of 'RetailPartner' element items. A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
     * 
     * @param list
     */
    public void setRetailPartnerList(List<RetailPartnerType> list) {
        retailPartnerList = list;
    }

    /** 
     * Get the list of 'TravelAgency' element items. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return list
     */
    public List<TravelAgencyType> getTravelAgencyList() {
        return travelAgencyList;
    }

    /** 
     * Set the list of 'TravelAgency' element items. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param list
     */
    public void setTravelAgencyList(List<TravelAgencyType> list) {
        travelAgencyList = list;
    }
}
