
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentAddressVerificationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="AddressVerificationInvalidInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="AddressVerificationNoMatchInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AddressVerificationStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AddressVerificationText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentAddressVerificationType implements Serializable
{
    private Boolean addressVerificationInvalidInd;
    private Boolean addressVerificationNoMatchInd;
    private String addressVerificationStatusCode;
    private String addressVerificationText;

    /** 
     * Get the 'AddressVerificationInvalidInd' element value. When true, the specified address was invalid.
     * 
     * @return value
     */
    public Boolean getAddressVerificationInvalidInd() {
        return addressVerificationInvalidInd;
    }

    /** 
     * Set the 'AddressVerificationInvalidInd' element value. When true, the specified address was invalid.
     * 
     * @param addressVerificationInvalidInd
     */
    public void setAddressVerificationInvalidInd(
            Boolean addressVerificationInvalidInd) {
        this.addressVerificationInvalidInd = addressVerificationInvalidInd;
    }

    /** 
     * Get the 'AddressVerificationNoMatchInd' element value. When true, the specified address could not be matched with issuing bank address on record.
     * 
     * @return value
     */
    public Boolean getAddressVerificationNoMatchInd() {
        return addressVerificationNoMatchInd;
    }

    /** 
     * Set the 'AddressVerificationNoMatchInd' element value. When true, the specified address could not be matched with issuing bank address on record.
     * 
     * @param addressVerificationNoMatchInd
     */
    public void setAddressVerificationNoMatchInd(
            Boolean addressVerificationNoMatchInd) {
        this.addressVerificationNoMatchInd = addressVerificationNoMatchInd;
    }

    /** 
     * Get the 'AddressVerificationStatusCode' element value. The address verification response code (AVS) when the ticketing agency performs address verification. Examples: X - Match: Street address and 9-digit ZIP code both match Y - Match: Street address and 5-digit ZIP code both match A - Partial Match: Street address matches, but both 5-digit and 9-digit ZIP Code do not match W - Partial Match: Street address does not match, but 9-digit ZIP code matches Z - Partial Match: Street address does not match, but 5-digit ZIP code matches N - No Match: Street address, 5-digit ZIP code, and 9-digit ZIP code all do not match U - System Unavailable: Address information unavailable. Returned if non-US. AVS is not available or if the AVS in a U.S. bank is not functioning properly. R - System Unavailable: Retry - Issuer's System Unavailable or Timed Out. E - Invalid: AVS data is invalid S - Not Supported: U.S. issuing bank does not support AVS
     * 
     * @return value
     */
    public String getAddressVerificationStatusCode() {
        return addressVerificationStatusCode;
    }

    /** 
     * Set the 'AddressVerificationStatusCode' element value. The address verification response code (AVS) when the ticketing agency performs address verification. Examples: X - Match: Street address and 9-digit ZIP code both match Y - Match: Street address and 5-digit ZIP code both match A - Partial Match: Street address matches, but both 5-digit and 9-digit ZIP Code do not match W - Partial Match: Street address does not match, but 9-digit ZIP code matches Z - Partial Match: Street address does not match, but 5-digit ZIP code matches N - No Match: Street address, 5-digit ZIP code, and 9-digit ZIP code all do not match U - System Unavailable: Address information unavailable. Returned if non-US. AVS is not available or if the AVS in a U.S. bank is not functioning properly. R - System Unavailable: Retry - Issuer's System Unavailable or Timed Out. E - Invalid: AVS data is invalid S - Not Supported: U.S. issuing bank does not support AVS
     * 
     * @param addressVerificationStatusCode
     */
    public void setAddressVerificationStatusCode(
            String addressVerificationStatusCode) {
        this.addressVerificationStatusCode = addressVerificationStatusCode;
    }

    /** 
     * Get the 'AddressVerificationText' element value. Additional Response Text from 3DS Provider.
     * 
     * @return value
     */
    public String getAddressVerificationText() {
        return addressVerificationText;
    }

    /** 
     * Set the 'AddressVerificationText' element value. Additional Response Text from 3DS Provider.
     * 
     * @param addressVerificationText
     */
    public void setAddressVerificationText(String addressVerificationText) {
        this.addressVerificationText = addressVerificationText;
    }
}
