
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Enumeration values for payment status codes. {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentStatusCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ACCEPTED"/>
 *     &lt;xs:enumeration value="ALLOCATED"/>
 *     &lt;xs:enumeration value="CLOSED"/>
 *     &lt;xs:enumeration value="COMMITTED"/>
 *     &lt;xs:enumeration value="RECEIVED"/>
 *     &lt;xs:enumeration value="REFUNDED"/>
 *     &lt;xs:enumeration value="SENT"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PaymentStatusCodeContentType implements Serializable {
    /** 
     * The commitments to pay was accepted./At the Payment Level to indicate that a payment has been authorized, etc.  or the status in not needed
     */
    ACCEPTED, /** 
               * The value of compensation was allocated to the corresponding Order Item.
               */
    ALLOCATED, /** 
                * The payment process was done.
                */
    CLOSED, /** 
             * The payer has committed to pay the compensation./When NDC indicates that part of a payment is to be applied to an order item
             */
    COMMITTED, /** 
                * The compensation was received./  The actual receipt of funds is a function of the accounting system, or it it expected that the revenue accounting system will update the order when the bank transmits funds to the airline?  Don't think we need this.
                */
    RECEIVED, /** 
               * The compensation was transfered back to the payer./When an order item is cancelled or changed, we expect that any payments applied to the item will be un-applied.  this leaves a credit balance on the order that can be applied to a new item of refunded.
               */
    REFUNDED, /** 
               * The compensation was transfered.
               */
    SENT
}
