
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Additional identification and URLs used to further describe a secure payment transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentTrxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DeviceType" name="Device" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="InputCurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="MaximumTryInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="NotProcessedInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginalID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentAddressVerificationType" name="PaymentAddressVerification" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="RetryInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SettlementCurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="TimestampDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TrxDataText" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="TrxID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TrxTypeText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentTrxType implements Serializable
{
    private String descText;
    private DeviceType device;
    private String inputCurCode;
    private Boolean maximumTryInd;
    private Boolean notProcessedInd;
    private String originalID;
    private PaymentAddressVerificationType paymentAddressVerification;
    private Boolean retryInd;
    private String settlementCurCode;
    private DateTimeType timestampDateTime;
    private List<String> trxDataTextList = new ArrayList<String>();
    private String trxID;
    private String trxTypeText;

    /** 
     * Get the 'DescText' element value. Transaction description information.  Ex: Air Fare Two PAX
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Transaction description information.  Ex: Air Fare Two PAX
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'Device' element value. Device upon which the secure transaction will occur.
     * 
     * @return value
     */
    public DeviceType getDevice() {
        return device;
    }

    /** 
     * Set the 'Device' element value. Device upon which the secure transaction will occur.
     * 
     * @param device
     */
    public void setDevice(DeviceType device) {
        this.device = device;
    }

    /** 
     * Get the 'InputCurCode' element value. Input Payment Currency code. Example: USD
     * 
     * @return value
     */
    public String getInputCurCode() {
        return inputCurCode;
    }

    /** 
     * Set the 'InputCurCode' element value. Input Payment Currency code. Example: USD
     * 
     * @param inputCurCode
     */
    public void setInputCurCode(String inputCurCode) {
        this.inputCurCode = inputCurCode;
    }

    /** 
     * Get the 'MaximumTryInd' element value. When TRUE, the maximum payment authentication attempts have been exceeded.
     * 
     * @return value
     */
    public Boolean getMaximumTryInd() {
        return maximumTryInd;
    }

    /** 
     * Set the 'MaximumTryInd' element value. When TRUE, the maximum payment authentication attempts have been exceeded.
     * 
     * @param maximumTryInd
     */
    public void setMaximumTryInd(Boolean maximumTryInd) {
        this.maximumTryInd = maximumTryInd;
    }

    /** 
     * Get the 'NotProcessedInd' element value. When TRUE, the payment information has not been processed.
     * 
     * @return value
     */
    public Boolean getNotProcessedInd() {
        return notProcessedInd;
    }

    /** 
     * Set the 'NotProcessedInd' element value. When TRUE, the payment information has not been processed.
     * 
     * @param notProcessedInd
     */
    public void setNotProcessedInd(Boolean notProcessedInd) {
        this.notProcessedInd = notProcessedInd;
    }

    /** 
     * Get the 'OriginalID' element value. The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345
     * 
     * @return value
     */
    public String getOriginalID() {
        return originalID;
    }

    /** 
     * Set the 'OriginalID' element value. The identifier of the original transaction that initiated this Traveler authentication. Example: TRN12345
     * 
     * @param originalID
     */
    public void setOriginalID(String originalID) {
        this.originalID = originalID;
    }

    /** 
     * Get the 'PaymentAddressVerification' element value. Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * 
     * @return value
     */
    public PaymentAddressVerificationType getPaymentAddressVerification() {
        return paymentAddressVerification;
    }

    /** 
     * Set the 'PaymentAddressVerification' element value. Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * 
     * @param paymentAddressVerification
     */
    public void setPaymentAddressVerification(
            PaymentAddressVerificationType paymentAddressVerification) {
        this.paymentAddressVerification = paymentAddressVerification;
    }

    /** 
     * Get the 'RetryInd' element value. When TRUE, the payment transaction should be present.
     * 
     * @return value
     */
    public Boolean getRetryInd() {
        return retryInd;
    }

    /** 
     * Set the 'RetryInd' element value. When TRUE, the payment transaction should be present.
     * 
     * @param retryInd
     */
    public void setRetryInd(Boolean retryInd) {
        this.retryInd = retryInd;
    }

    /** 
     * Get the 'SettlementCurCode' element value. Settlement Payment Currency code. Example: CHF
     * 
     * @return value
     */
    public String getSettlementCurCode() {
        return settlementCurCode;
    }

    /** 
     * Set the 'SettlementCurCode' element value. Settlement Payment Currency code. Example: CHF
     * 
     * @param settlementCurCode
     */
    public void setSettlementCurCode(String settlementCurCode) {
        this.settlementCurCode = settlementCurCode;
    }

    /** 
     * Get the 'TimestampDateTime' element value. 3DS transaction timestamp.
     * 
     * @return value
     */
    public DateTimeType getTimestampDateTime() {
        return timestampDateTime;
    }

    /** 
     * Set the 'TimestampDateTime' element value. 3DS transaction timestamp.
     * 
     * @param timestampDateTime
     */
    public void setTimestampDateTime(DateTimeType timestampDateTime) {
        this.timestampDateTime = timestampDateTime;
    }

    /** 
     * Get the list of 'TrxDataText' element items. Other (free form text) transaction data.
     * 
     * @return list
     */
    public List<String> getTrxDataTextList() {
        return trxDataTextList;
    }

    /** 
     * Set the list of 'TrxDataText' element items. Other (free form text) transaction data.
     * 
     * @param list
     */
    public void setTrxDataTextList(List<String> list) {
        trxDataTextList = list;
    }

    /** 
     * Get the 'TrxID' element value. Globally unique ID for a transaction processing instance.
     * 
     * @return value
     */
    public String getTrxID() {
        return trxID;
    }

    /** 
     * Set the 'TrxID' element value. Globally unique ID for a transaction processing instance.
     * 
     * @param trxID
     */
    public void setTrxID(String trxID) {
        this.trxID = trxID;
    }

    /** 
     * Get the 'TrxTypeText' element value. 3D Secure Transaction Type.  Examples: Authorize: Authorize amount (no funds transferred) Complete: Complete a previous authorization (funds are transferred) Purchase: Purchase (funds are transferred immediately) Refund: Refund (funds transferred immediately) Validate: Validation Transaction (a small authorized transaction amount to validate card details including expiry date and address)
     * 
     * @return value
     */
    public String getTrxTypeText() {
        return trxTypeText;
    }

    /** 
     * Set the 'TrxTypeText' element value. 3D Secure Transaction Type.  Examples: Authorize: Authorize amount (no funds transferred) Complete: Complete a previous authorization (funds are transferred) Purchase: Purchase (funds are transferred immediately) Refund: Refund (funds transferred immediately) Validate: Validation Transaction (a small authorized transaction amount to validate card details including expiry date and address)
     * 
     * @param trxTypeText
     */
    public void setTrxTypeText(String trxTypeText) {
        this.trxTypeText = trxTypeText;
    }
}
