
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Defines the maximum number of each allowable baggage type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PieceAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableBagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ApplicablePartyText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Desc" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:DimensionAllowanceType" name="PieceDimensionAllowance" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:WeightAllowanceType" name="PieceWeightAllowance" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:QtyType" name="TotalQty" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PieceAllowanceType implements Serializable
{
    private String applicableBagText;
    private String applicablePartyText;
    private List<String> descList = new ArrayList<String>();
    private List<DimensionAllowanceType> pieceDimensionAllowanceList = new ArrayList<DimensionAllowanceType>();
    private List<WeightAllowanceType> pieceWeightAllowanceList = new ArrayList<WeightAllowanceType>();
    private QtyType totalQty;
    private String typeText;

    /** 
     * Get the 'ApplicableBagText' element value. Applicable bag type. Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBagText() {
        return applicableBagText;
    }

    /** 
     * Set the 'ApplicableBagText' element value. Applicable bag type. Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBagText
     */
    public void setApplicableBagText(String applicableBagText) {
        this.applicableBagText = applicableBagText;
    }

    /** 
     * Get the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicablePartyText() {
        return applicablePartyText;
    }

    /** 
     * Set the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @param applicablePartyText
     */
    public void setApplicablePartyText(String applicablePartyText) {
        this.applicablePartyText = applicablePartyText;
    }

    /** 
     * Get the list of 'Desc' element items. Piece allowance description and additional information.
     * 
     * @return list
     */
    public List<String> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. Piece allowance description and additional information.
     * 
     * @param list
     */
    public void setDescList(List<String> list) {
        descList = list;
    }

    /** 
     * Get the list of 'PieceDimensionAllowance' element items. Baggage dimension allowance with application information.
     * 
     * @return list
     */
    public List<DimensionAllowanceType> getPieceDimensionAllowanceList() {
        return pieceDimensionAllowanceList;
    }

    /** 
     * Set the list of 'PieceDimensionAllowance' element items. Baggage dimension allowance with application information.
     * 
     * @param list
     */
    public void setPieceDimensionAllowanceList(List<DimensionAllowanceType> list) {
        pieceDimensionAllowanceList = list;
    }

    /** 
     * Get the list of 'PieceWeightAllowance' element items. Baggage weight allowance with application information.
     * 
     * @return list
     */
    public List<WeightAllowanceType> getPieceWeightAllowanceList() {
        return pieceWeightAllowanceList;
    }

    /** 
     * Set the list of 'PieceWeightAllowance' element items. Baggage weight allowance with application information.
     * 
     * @param list
     */
    public void setPieceWeightAllowanceList(List<WeightAllowanceType> list) {
        pieceWeightAllowanceList = list;
    }

    /** 
     * Get the 'TotalQty' element value. Maximum pieces of baggage allowed. Example: 4
     * 
     * @return value
     */
    public QtyType getTotalQty() {
        return totalQty;
    }

    /** 
     * Set the 'TotalQty' element value. Maximum pieces of baggage allowed. Example: 4
     * 
     * @param totalQty
     */
    public void setTotalQty(QtyType totalQty) {
        this.totalQty = totalQty;
    }

    /** 
     * Get the 'TypeText' element value. Type of bag. Example: Golf Equipment, Fishing Bag, Car Seat, etc.
     * 
     * @return value
     */
    public String getTypeText() {
        return typeText;
    }

    /** 
     * Set the 'TypeText' element value. Type of bag. Example: Golf Equipment, Fishing Bag, Car Seat, etc.
     * 
     * @param typeText
     */
    public void setTypeText(String typeText) {
        this.typeText = typeText;
    }
}
