
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * response to PNR queue placement
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQPCR_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_PlacePNRReply">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="errorReturn" minOccurs="0">
 *         &lt;!-- Reference to inner class ErrorReturn -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:ReservationControlInformationTypeI" name="recordLocator" minOccurs="0"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueuePlacePNRReply implements Serializable
{
    private ErrorReturn errorReturn;
    private ReservationControlInformationTypeI recordLocator;

    /** 
     * Get the 'errorReturn' element value.
     * 
     * @return value
     */
    public ErrorReturn getErrorReturn() {
        return errorReturn;
    }

    /** 
     * Set the 'errorReturn' element value.
     * 
     * @param errorReturn
     */
    public void setErrorReturn(ErrorReturn errorReturn) {
        this.errorReturn = errorReturn;
    }

    /** 
     * Get the 'recordLocator' element value. record locator
     * 
     * @return value
     */
    public ReservationControlInformationTypeI getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'recordLocator' element value. record locator
     * 
     * @param recordLocator
     */
    public void setRecordLocator(
            ReservationControlInformationTypeI recordLocator) {
        this.recordLocator = recordLocator;
    }
    /** 
     * any errors should be returned in this group
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQPCR_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="errorReturn" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ApplicationErrorInformationTypeI" name="errorDefinition"/>
     *       &lt;xs:element type="ns:FreeTextInformationType" name="errorText" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ErrorReturn implements Serializable
    {
        private ApplicationErrorInformationTypeI errorDefinition;
        private FreeTextInformationType errorText;

        /** 
         * Get the 'errorDefinition' element value. returns the error code
         * 
         * @return value
         */
        public ApplicationErrorInformationTypeI getErrorDefinition() {
            return errorDefinition;
        }

        /** 
         * Set the 'errorDefinition' element value. returns the error code
         * 
         * @param errorDefinition
         */
        public void setErrorDefinition(
                ApplicationErrorInformationTypeI errorDefinition) {
            this.errorDefinition = errorDefinition;
        }

        /** 
         * Get the 'errorText' element value. contains the text of the error
         * 
         * @return value
         */
        public FreeTextInformationType getErrorText() {
            return errorText;
        }

        /** 
         * Set the 'errorText' element value. contains the text of the error
         * 
         * @param errorText
         */
        public void setErrorText(FreeTextInformationType errorText) {
            this.errorText = errorText;
        }
    }
}
