
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Additional, supplementary information about the document or service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RemarkType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="DisplayInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RemarkText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="Timestamp" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RemarkType implements Serializable
{
    private Boolean displayInd;
    private String remarkText;
    private DateTimeType timestamp;

    /** 
     * Get the 'DisplayInd' element value. When TRUE, this remark should be displayed.  Notes: 1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification.
     * 
     * @return value
     */
    public Boolean getDisplayInd() {
        return displayInd;
    }

    /** 
     * Set the 'DisplayInd' element value. When TRUE, this remark should be displayed.  Notes: 1. This capability may not be supported by all NDC-enabled systems or may be supported by bilateral agreement only.  The technical implementation of this capability is not dictated by this specification.
     * 
     * @param displayInd
     */
    public void setDisplayInd(Boolean displayInd) {
        this.displayInd = displayInd;
    }

    /** 
     * Get the 'RemarkText' element value. Additional, supplementary information about the document or service.
     * 
     * @return value
     */
    public String getRemarkText() {
        return remarkText;
    }

    /** 
     * Set the 'RemarkText' element value. Additional, supplementary information about the document or service.
     * 
     * @param remarkText
     */
    public void setRemarkText(String remarkText) {
        this.remarkText = remarkText;
    }

    /** 
     * Get the 'Timestamp' element value. Remark creation timestamp.
     * 
     * @return value
     */
    public DateTimeType getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value. Remark creation timestamp.
     * 
     * @param timestamp
     */
    public void setTimestamp(DateTimeType timestamp) {
        this.timestamp = timestamp;
    }
}
