
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Payload information for OrderViewRS.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DataListsType" name="DataLists" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MetadataType" name="Metadata" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderType" name="Order" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ResponseParametersType" name="Processing" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketDocInfoType" name="TicketDocInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:WarningType" name="Warning" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseType implements Serializable
{
    private CommissionType commission;
    private DataListsType dataLists;
    private MetadataType metadata;
    private List<OrderType> orderList = new ArrayList<OrderType>();
    private ResponseParametersType processing;
    private List<TicketDocInfoType> ticketDocInfoList = new ArrayList<TicketDocInfoType>();
    private List<WarningType> warningList = new ArrayList<WarningType>();

    /** 
     * Get the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'DataLists' element value. Data List definition for this message.
     * 
     * @return value
     */
    public DataListsType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data List definition for this message.
     * 
     * @param dataLists
     */
    public void setDataLists(DataListsType dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Message wide metadata information.
     * 
     * @return value
     */
    public MetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Message wide metadata information.
     * 
     * @param metadata
     */
    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the list of 'Order' element items. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @return list
     */
    public List<OrderType> getOrderList() {
        return orderList;
    }

    /** 
     * Set the list of 'Order' element items. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @param list
     */
    public void setOrderList(List<OrderType> list) {
        orderList = list;
    }

    /** 
     * Get the 'Processing' element value. Information related to how response results should be returned.
     * 
     * @return value
     */
    public ResponseParametersType getProcessing() {
        return processing;
    }

    /** 
     * Set the 'Processing' element value. Information related to how response results should be returned.
     * 
     * @param processing
     */
    public void setProcessing(ResponseParametersType processing) {
        this.processing = processing;
    }

    /** 
     * Get the list of 'TicketDocInfo' element items. Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
     * 
     * @return list
     */
    public List<TicketDocInfoType> getTicketDocInfoList() {
        return ticketDocInfoList;
    }

    /** 
     * Set the list of 'TicketDocInfo' element items. Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
     * 
     * @param list
     */
    public void setTicketDocInfoList(List<TicketDocInfoType> list) {
        ticketDocInfoList = list;
    }

    /** 
     * Get the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @return list
     */
    public List<WarningType> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @param list
     */
    public void setWarningList(List<WarningType> list) {
        warningList = list;
    }
}
