
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatonLegType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DatedOperatingLegRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OccupationStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatType" name="Seat" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatonLegType implements Serializable
{
    private String datedOperatingLegRefID;
    private String occupationStatusCode;
    private SeatType seat;

    /** 
     * Get the 'DatedOperatingLegRefID' element value. Reference to a Leg ID within this message.
     * 
     * @return value
     */
    public String getDatedOperatingLegRefID() {
        return datedOperatingLegRefID;
    }

    /** 
     * Set the 'DatedOperatingLegRefID' element value. Reference to a Leg ID within this message.
     * 
     * @param datedOperatingLegRefID
     */
    public void setDatedOperatingLegRefID(String datedOperatingLegRefID) {
        this.datedOperatingLegRefID = datedOperatingLegRefID;
    }

    /** 
     * Get the 'OccupationStatusCode' element value. Information related to the availability of a particular Seat on Leg.
     * 
     * @return value
     */
    public String getOccupationStatusCode() {
        return occupationStatusCode;
    }

    /** 
     * Set the 'OccupationStatusCode' element value. Information related to the availability of a particular Seat on Leg.
     * 
     * @param occupationStatusCode
     */
    public void setOccupationStatusCode(String occupationStatusCode) {
        this.occupationStatusCode = occupationStatusCode;
    }

    /** 
     * Get the 'Seat' element value. A sitting place for a passenger located in the cabin.
     * 
     * @return value
     */
    public SeatType getSeat() {
        return seat;
    }

    /** 
     * Set the 'Seat' element value. A sitting place for a passenger located in the cabin.
     * 
     * @param seat
     */
    public void setSeat(SeatType seat) {
        this.seat = seat;
    }
}
