
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Contains enrolment information of the Payment Card.  e.g. Verified by Visa.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SecureProgramType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="EnrollmentStatusText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SecurePaymentProgramName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SecureProgramType implements Serializable
{
    private String enrollmentStatusText;
    private String securePaymentProgramName;

    /** 
     * Get the 'EnrollmentStatusText' element value. 3D Secure Program Enrollment Status. Examples: CardNotEnrolled, CardEnrolled, CardMayBeEnrolled, Unknown
     * 
     * @return value
     */
    public String getEnrollmentStatusText() {
        return enrollmentStatusText;
    }

    /** 
     * Set the 'EnrollmentStatusText' element value. 3D Secure Program Enrollment Status. Examples: CardNotEnrolled, CardEnrolled, CardMayBeEnrolled, Unknown
     * 
     * @param enrollmentStatusText
     */
    public void setEnrollmentStatusText(String enrollmentStatusText) {
        this.enrollmentStatusText = enrollmentStatusText;
    }

    /** 
     * Get the 'SecurePaymentProgramName' element value. Name of the secure payment program.  E.g. Verified by Visa.
     * 
     * @return value
     */
    public String getSecurePaymentProgramName() {
        return securePaymentProgramName;
    }

    /** 
     * Set the 'SecurePaymentProgramName' element value. Name of the secure payment program.  E.g. Verified by Visa.
     * 
     * @param securePaymentProgramName
     */
    public void setSecurePaymentProgramName(String securePaymentProgramName) {
        this.securePaymentProgramName = securePaymentProgramName;
    }
}
