
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Description and characteristics of a non-flight product or service that can be separately sold and delivered. E.g. bag, seat, meal on a flight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BilateralTimeLimitType" name="BilateralTimeLimit" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:BookingInstructionsType" name="BookingInstructions" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="DepositTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="NamingTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFIC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFISC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceDefinitionAssociationType" name="ServiceDefinitionAssociation" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDefinitionID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SpecialServiceType" name="SpecialService" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrierCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceDefinitionType implements Serializable
{
    private List<BilateralTimeLimitType> bilateralTimeLimitList = new ArrayList<BilateralTimeLimitType>();
    private BookingInstructionsType bookingInstructions;
    private DateTimeType depositTimeLimitDateTime;
    private List<DescType> descList = new ArrayList<DescType>();
    private String name;
    private DateTimeType namingTimeLimitDateTime;
    private String ownerCode;
    private String RFIC;
    private String RFISC;
    private String serviceCode;
    private ServiceDefinitionAssociationType serviceDefinitionAssociation;
    private String serviceDefinitionID;
    private List<SpecialServiceType> specialServiceList = new ArrayList<SpecialServiceType>();
    private String validatingCarrierCode;

    /** 
     * Get the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @return list
     */
    public List<BilateralTimeLimitType> getBilateralTimeLimitList() {
        return bilateralTimeLimitList;
    }

    /** 
     * Set the list of 'BilateralTimeLimit' element items. A bilaterally agreed limitation or restriction of time.
     * 
     * @param list
     */
    public void setBilateralTimeLimitList(List<BilateralTimeLimitType> list) {
        bilateralTimeLimitList = list;
    }

    /** 
     * Get the 'BookingInstructions' element value. Optional service booking instructions to include SSR, OSI and upgrade Method.
     * 
     * @return value
     */
    public BookingInstructionsType getBookingInstructions() {
        return bookingInstructions;
    }

    /** 
     * Set the 'BookingInstructions' element value. Optional service booking instructions to include SSR, OSI and upgrade Method.
     * 
     * @param bookingInstructions
     */
    public void setBookingInstructions(
            BookingInstructionsType bookingInstructions) {
        this.bookingInstructions = bookingInstructions;
    }

    /** 
     * Get the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getDepositTimeLimitDateTime() {
        return depositTimeLimitDateTime;
    }

    /** 
     * Set the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @param depositTimeLimitDateTime
     */
    public void setDepositTimeLimitDateTime(
            DateTimeType depositTimeLimitDateTime) {
        this.depositTimeLimitDateTime = depositTimeLimitDateTime;
    }

    /** 
     * Get the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setDescList(List<DescType> list) {
        descList = list;
    }

    /** 
     * Get the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Service name. Example: Lounge Pass
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getNamingTimeLimitDateTime() {
        return namingTimeLimitDateTime;
    }

    /** 
     * Set the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @param namingTimeLimitDateTime
     */
    public void setNamingTimeLimitDateTime(DateTimeType namingTimeLimitDateTime) {
        this.namingTimeLimitDateTime = namingTimeLimitDateTime;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'RFIC' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services)
     * 
     * @return value
     */
    public String getRFIC() {
        return RFIC;
    }

    /** 
     * Set the 'RFIC' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services)
     * 
     * @param RFIC
     */
    public void setRFIC(String RFIC) {
        this.RFIC = RFIC;
    }

    /** 
     * Get the 'RFISC' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @return value
     */
    public String getRFISC() {
        return RFISC;
    }

    /** 
     * Set the 'RFISC' element value. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @param RFISC
     */
    public void setRFISC(String RFISC) {
        this.RFISC = RFISC;
    }

    /** 
     * Get the 'ServiceCode' element value. Airline specific service code which can be associated with the Reason for Issuance Sub Code.  Sample implementer encoding: XLEG for Extra Leg Room Seat XBAG for Extra Bag
     * 
     * @return value
     */
    public String getServiceCode() {
        return serviceCode;
    }

    /** 
     * Set the 'ServiceCode' element value. Airline specific service code which can be associated with the Reason for Issuance Sub Code.  Sample implementer encoding: XLEG for Extra Leg Room Seat XBAG for Extra Bag
     * 
     * @param serviceCode
     */
    public void setServiceCode(String serviceCode) {
        this.serviceCode = serviceCode;
    }

    /** 
     * Get the 'ServiceDefinitionAssociation' element value. Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics, or whether the ServiceDefinition is used as a bundle of further ServiceDefinitions.
     * 
     * @return value
     */
    public ServiceDefinitionAssociationType getServiceDefinitionAssociation() {
        return serviceDefinitionAssociation;
    }

    /** 
     * Set the 'ServiceDefinitionAssociation' element value. Choice to determine if the information of this ServiceDefinition needs to be extended with specific Bag or Seat characteristics, or whether the ServiceDefinition is used as a bundle of further ServiceDefinitions.
     * 
     * @param serviceDefinitionAssociation
     */
    public void setServiceDefinitionAssociation(
            ServiceDefinitionAssociationType serviceDefinitionAssociation) {
        this.serviceDefinitionAssociation = serviceDefinitionAssociation;
    }

    /** 
     * Get the 'ServiceDefinitionID' element value. Uniquely Identifies a Service Definition within the context of one message.
     * 
     * @return value
     */
    public String getServiceDefinitionID() {
        return serviceDefinitionID;
    }

    /** 
     * Set the 'ServiceDefinitionID' element value. Uniquely Identifies a Service Definition within the context of one message.
     * 
     * @param serviceDefinitionID
     */
    public void setServiceDefinitionID(String serviceDefinitionID) {
        this.serviceDefinitionID = serviceDefinitionID;
    }

    /** 
     * Get the list of 'SpecialService' element items. Special service information
     * 
     * @return list
     */
    public List<SpecialServiceType> getSpecialServiceList() {
        return specialServiceList;
    }

    /** 
     * Set the list of 'SpecialService' element items. Special service information
     * 
     * @param list
     */
    public void setSpecialServiceList(List<SpecialServiceType> list) {
        specialServiceList = list;
    }

    /** 
     * Get the 'ValidatingCarrierCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getValidatingCarrierCode() {
        return validatingCarrierCode;
    }

    /** 
     * Set the 'ValidatingCarrierCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param validatingCarrierCode
     */
    public void setValidatingCarrierCode(String validatingCarrierCode) {
        this.validatingCarrierCode = validatingCarrierCode;
    }
}
