
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information corresponding to a group of 1 to 4 Tickets for a single Origin Destination and a single Passenger.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketDocInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BaggageAllowanceRefID" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="BookingAgency" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRef" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:QtyType" name="BookletQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierFeeType" name="CarrierFee" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="EndorsementText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderRefType" name="OrderRef" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketIssuanceInfoType" name="OriginalIssueInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginDestType" name="OriginDest" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentInfoRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PenaltyRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PricingCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="PricingDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PricingLocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="PricingTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderType" name="ReferencedOrder" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="ServicingAgency" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TicketType" name="Ticket" minOccurs="1" maxOccurs="4"/>
 *     &lt;xs:element type="ns:TicketRefIdentificationType" name="TicketRefIdentification" minOccurs="0" maxOccurs="5"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketDocInfoType implements Serializable
{
    private List<String> baggageAllowanceRefIDList = new ArrayList<String>();
    private TravelAgencyType bookingAgency;
    private List<BookingRefType> bookingRefList = new ArrayList<BookingRefType>();
    private QtyType bookletQty;
    private CarrierFeeType carrierFee;
    private CommissionType commission;
    private String endorsementText;
    private FareDetailType fareDetail;
    private OrderRefType orderRef;
    private TicketIssuanceInfoType originalIssueInfo;
    private OriginDestType originDest;
    private String paxRefID;
    private List<String> paymentInfoRefIDList = new ArrayList<String>();
    private List<String> penaltyRefIDList = new ArrayList<String>();
    private String pricingCountryCode;
    private Date pricingDate;
    private String pricingLocationCode;
    private java.util.Date pricingTime;
    private OrderType referencedOrder;
    private TravelAgencyType servicingAgency;
    private List<TicketType> ticketList = new ArrayList<TicketType>();
    private List<TicketRefIdentificationType> ticketRefIdentificationList = new ArrayList<TicketRefIdentificationType>();

    /** 
     * Get the list of 'BaggageAllowanceRefID' element items. Reference to a BaggageAllowanceID
     * 
     * @return list
     */
    public List<String> getBaggageAllowanceRefIDList() {
        return baggageAllowanceRefIDList;
    }

    /** 
     * Set the list of 'BaggageAllowanceRefID' element items. Reference to a BaggageAllowanceID
     * 
     * @param list
     */
    public void setBaggageAllowanceRefIDList(List<String> list) {
        baggageAllowanceRefIDList = list;
    }

    /** 
     * Get the 'BookingAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getBookingAgency() {
        return bookingAgency;
    }

    /** 
     * Set the 'BookingAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param bookingAgency
     */
    public void setBookingAgency(TravelAgencyType bookingAgency) {
        this.bookingAgency = bookingAgency;
    }

    /** 
     * Get the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @return list
     */
    public List<BookingRefType> getBookingRefList() {
        return bookingRefList;
    }

    /** 
     * Set the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @param list
     */
    public void setBookingRefList(List<BookingRefType> list) {
        bookingRefList = list;
    }

    /** 
     * Get the 'BookletQty' element value. Number of booklets issued for a given ticket/ document set.
     * 
     * @return value
     */
    public QtyType getBookletQty() {
        return bookletQty;
    }

    /** 
     * Set the 'BookletQty' element value. Number of booklets issued for a given ticket/ document set.
     * 
     * @param bookletQty
     */
    public void setBookletQty(QtyType bookletQty) {
        this.bookletQty = bookletQty;
    }

    /** 
     * Get the 'CarrierFee' element value. Carrier imposed fee detail, typically related to booking, ticketing, or servicing.
     * 
     * @return value
     */
    public CarrierFeeType getCarrierFee() {
        return carrierFee;
    }

    /** 
     * Set the 'CarrierFee' element value. Carrier imposed fee detail, typically related to booking, ticketing, or servicing.
     * 
     * @param carrierFee
     */
    public void setCarrierFee(CarrierFeeType carrierFee) {
        this.carrierFee = carrierFee;
    }

    /** 
     * Get the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'EndorsementText' element value. Endorsement and restriction information applied for this set of ticket / document information.
     * 
     * @return value
     */
    public String getEndorsementText() {
        return endorsementText;
    }

    /** 
     * Set the 'EndorsementText' element value. Endorsement and restriction information applied for this set of ticket / document information.
     * 
     * @param endorsementText
     */
    public void setEndorsementText(String endorsementText) {
        this.endorsementText = endorsementText;
    }

    /** 
     * Get the 'FareDetail' element value. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the 'OrderRef' element value. Associated order information.
     * 
     * @return value
     */
    public OrderRefType getOrderRef() {
        return orderRef;
    }

    /** 
     * Set the 'OrderRef' element value. Associated order information.
     * 
     * @param orderRef
     */
    public void setOrderRef(OrderRefType orderRef) {
        this.orderRef = orderRef;
    }

    /** 
     * Get the 'OriginalIssueInfo' element value. The issuing carrier and issuing location of a ticket.
     * 
     * @return value
     */
    public TicketIssuanceInfoType getOriginalIssueInfo() {
        return originalIssueInfo;
    }

    /** 
     * Set the 'OriginalIssueInfo' element value. The issuing carrier and issuing location of a ticket.
     * 
     * @param originalIssueInfo
     */
    public void setOriginalIssueInfo(TicketIssuanceInfoType originalIssueInfo) {
        this.originalIssueInfo = originalIssueInfo;
    }

    /** 
     * Get the 'OriginDest' element value. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @return value
     */
    public OriginDestType getOriginDest() {
        return originDest;
    }

    /** 
     * Set the 'OriginDest' element value. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @param originDest
     */
    public void setOriginDest(OriginDestType originDest) {
        this.originDest = originDest;
    }

    /** 
     * Get the 'PaxRefID' element value. Reference to a Passenger ID.
     * 
     * @return value
     */
    public String getPaxRefID() {
        return paxRefID;
    }

    /** 
     * Set the 'PaxRefID' element value. Reference to a Passenger ID.
     * 
     * @param paxRefID
     */
    public void setPaxRefID(String paxRefID) {
        this.paxRefID = paxRefID;
    }

    /** 
     * Get the list of 'PaymentInfoRefID' element items. Reference to a Payment Information ID.
     * 
     * @return list
     */
    public List<String> getPaymentInfoRefIDList() {
        return paymentInfoRefIDList;
    }

    /** 
     * Set the list of 'PaymentInfoRefID' element items. Reference to a Payment Information ID.
     * 
     * @param list
     */
    public void setPaymentInfoRefIDList(List<String> list) {
        paymentInfoRefIDList = list;
    }

    /** 
     * Get the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @return list
     */
    public List<String> getPenaltyRefIDList() {
        return penaltyRefIDList;
    }

    /** 
     * Set the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @param list
     */
    public void setPenaltyRefIDList(List<String> list) {
        penaltyRefIDList = list;
    }

    /** 
     * Get the 'PricingCountryCode' element value. The country code used to identify the country in which the booked itinerary was priced.
     * 
     * @return value
     */
    public String getPricingCountryCode() {
        return pricingCountryCode;
    }

    /** 
     * Set the 'PricingCountryCode' element value. The country code used to identify the country in which the booked itinerary was priced.
     * 
     * @param pricingCountryCode
     */
    public void setPricingCountryCode(String pricingCountryCode) {
        this.pricingCountryCode = pricingCountryCode;
    }

    /** 
     * Get the 'PricingDate' element value. Booked Itinerary Pricing Date. Example: 2017-01-13 Note: This is the date the booked itinerary was priced.
     * 
     * @return value
     */
    public Date getPricingDate() {
        return pricingDate;
    }

    /** 
     * Set the 'PricingDate' element value. Booked Itinerary Pricing Date. Example: 2017-01-13 Note: This is the date the booked itinerary was priced.
     * 
     * @param pricingDate
     */
    public void setPricingDate(Date pricingDate) {
        this.pricingDate = pricingDate;
    }

    /** 
     * Get the 'PricingLocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getPricingLocationCode() {
        return pricingLocationCode;
    }

    /** 
     * Set the 'PricingLocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param pricingLocationCode
     */
    public void setPricingLocationCode(String pricingLocationCode) {
        this.pricingLocationCode = pricingLocationCode;
    }

    /** 
     * Get the 'PricingTime' element value. Booked Itinerary Pricing Time. Example: 09:15
     * 
     * @return value
     */
    public java.util.Date getPricingTime() {
        return pricingTime;
    }

    /** 
     * Set the 'PricingTime' element value. Booked Itinerary Pricing Time. Example: 09:15
     * 
     * @param pricingTime
     */
    public void setPricingTime(java.util.Date pricingTime) {
        this.pricingTime = pricingTime;
    }

    /** 
     * Get the 'ReferencedOrder' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @return value
     */
    public OrderType getReferencedOrder() {
        return referencedOrder;
    }

    /** 
     * Set the 'ReferencedOrder' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @param referencedOrder
     */
    public void setReferencedOrder(OrderType referencedOrder) {
        this.referencedOrder = referencedOrder;
    }

    /** 
     * Get the 'ServicingAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getServicingAgency() {
        return servicingAgency;
    }

    /** 
     * Set the 'ServicingAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param servicingAgency
     */
    public void setServicingAgency(TravelAgencyType servicingAgency) {
        this.servicingAgency = servicingAgency;
    }

    /** 
     * Get the list of 'Ticket' element items. The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * 
     * @return list
     */
    public List<TicketType> getTicketList() {
        return ticketList;
    }

    /** 
     * Set the list of 'Ticket' element items. The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
     * 
     * @param list
     */
    public void setTicketList(List<TicketType> list) {
        ticketList = list;
    }

    /** 
     * Get the list of 'TicketRefIdentification' element items. Additional, identifying information used to identify a ticket.
     * 
     * @return list
     */
    public List<TicketRefIdentificationType> getTicketRefIdentificationList() {
        return ticketRefIdentificationList;
    }

    /** 
     * Set the list of 'TicketRefIdentification' element items. Additional, identifying information used to identify a ticket.
     * 
     * @param list
     */
    public void setTicketRefIdentificationList(
            List<TicketRefIdentificationType> list) {
        ticketRefIdentificationList = list;
    }
}
