
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.sql.Date;

/** 
 * The issuing carrier and issuing location of a ticket.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketIssuanceInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="IATA_LocationCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="IssueDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgencyID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IssuingAirlineDesigCode" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketIssuanceInfoType implements Serializable
{
    private String IATALocationCode;
    private Date issueDate;
    private String issuingAgencyID;
    private String issuingAirlineDesigCode;

    /** 
     * Get the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @return value
     */
    public String getIATALocationCode() {
        return IATALocationCode;
    }

    /** 
     * Set the 'IATA_LocationCode' element value. IATA defined code identifying a city or station.
     * 
     * @param IATALocationCode
     */
    public void setIATALocationCode(String IATALocationCode) {
        this.IATALocationCode = IATALocationCode;
    }

    /** 
     * Get the 'IssueDate' element value. The date that the document was originally issued.
     * 
     * @return value
     */
    public Date getIssueDate() {
        return issueDate;
    }

    /** 
     * Set the 'IssueDate' element value. The date that the document was originally issued.
     * 
     * @param issueDate
     */
    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /** 
     * Get the 'IssuingAgencyID' element value. Unique Agency Seller ID. Example: CTRV
     * 
     * @return value
     */
    public String getIssuingAgencyID() {
        return issuingAgencyID;
    }

    /** 
     * Set the 'IssuingAgencyID' element value. Unique Agency Seller ID. Example: CTRV
     * 
     * @param issuingAgencyID
     */
    public void setIssuingAgencyID(String issuingAgencyID) {
        this.issuingAgencyID = issuingAgencyID;
    }

    /** 
     * Get the 'IssuingAirlineDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getIssuingAirlineDesigCode() {
        return issuingAirlineDesigCode;
    }

    /** 
     * Set the 'IssuingAirlineDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param issuingAirlineDesigCode
     */
    public void setIssuingAirlineDesigCode(String issuingAirlineDesigCode) {
        this.issuingAirlineDesigCode = issuingAirlineDesigCode;
    }
}
