
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Function to accept a new OfferItem and adding it to the existing Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptOfferType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:CreateOrderItemType" name="CreateOrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SelectedOfferType" name="SelectedOffer" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AcceptOfferType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CREATE_ORDER_ITEM_LIST_CHOICE = 0;
    private static final int SELECTED_OFFER_LIST_CHOICE = 1;
    private List<CreateOrderItemType> createOrderItemList = new ArrayList<CreateOrderItemType>();
    private List<SelectedOfferType> selectedOfferList = new ArrayList<SelectedOfferType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CreateOrderItemList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCreateOrderItemList() {
        return choiceSelect == CREATE_ORDER_ITEM_LIST_CHOICE;
    }

    /** 
     * Get the list of 'CreateOrderItem' element items. Used for selling by value (long sells) rather than selling by reference.
     * 
     * @return list
     */
    public List<CreateOrderItemType> getCreateOrderItemList() {
        return createOrderItemList;
    }

    /** 
     * Set the list of 'CreateOrderItem' element items. Used for selling by value (long sells) rather than selling by reference.
     * 
     * @param list
     */
    public void setCreateOrderItemList(List<CreateOrderItemType> list) {
        setChoiceSelect(CREATE_ORDER_ITEM_LIST_CHOICE);
        createOrderItemList = list;
    }

    /** 
     * Check if SelectedOfferList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSelectedOfferList() {
        return choiceSelect == SELECTED_OFFER_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SelectedOffer' element items. Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs).   Each Offer selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and â€œa-la-carteâ€&#157; Offers would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * 
     * @return list
     */
    public List<SelectedOfferType> getSelectedOfferList() {
        return selectedOfferList;
    }

    /** 
     * Set the list of 'SelectedOffer' element items. Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs).   Each Offer selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and â€œa-la-carteâ€&#157; Offers would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * 
     * @param list
     */
    public void setSelectedOfferList(List<SelectedOfferType> list) {
        setChoiceSelect(SELECTED_OFFER_LIST_CHOICE);
        selectedOfferList = list;
    }
}
