
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Function used by seller to inform the airline that it is accepting the proposed Order, as it has been repriced and returned in the preceding OrderReshopRS.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AcceptRepricedOrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ShoppingResponseRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AcceptRepricedOrderType implements Serializable
{
    private String offerRefID;
    private String shoppingResponseRefID;

    /** 
     * Get the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @return value
     */
    public String getOfferRefID() {
        return offerRefID;
    }

    /** 
     * Set the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @param offerRefID
     */
    public void setOfferRefID(String offerRefID) {
        this.offerRefID = offerRefID;
    }

    /** 
     * Get the 'ShoppingResponseRefID' element value. Reference to a shopping response ID.
     * 
     * @return value
     */
    public String getShoppingResponseRefID() {
        return shoppingResponseRefID;
    }

    /** 
     * Set the 'ShoppingResponseRefID' element value. Reference to a shopping response ID.
     * 
     * @param shoppingResponseRefID
     */
    public void setShoppingResponseRefID(String shoppingResponseRefID) {
        this.shoppingResponseRefID = shoppingResponseRefID;
    }
}
