
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AllianceCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceType implements Serializable
{
    private String allianceCode;
    private List<CarrierType> carrierList = new ArrayList<CarrierType>();
    private String name;
    private String URL;

    /** 
     * Get the 'AllianceCode' element value. Used to specify the alliance based on PADIS Code List (code list defined in BDT).
     * 
     * @return value
     */
    public String getAllianceCode() {
        return allianceCode;
    }

    /** 
     * Set the 'AllianceCode' element value. Used to specify the alliance based on PADIS Code List (code list defined in BDT).
     * 
     * @param allianceCode
     */
    public void setAllianceCode(String allianceCode) {
        this.allianceCode = allianceCode;
    }

    /** 
     * Get the list of 'Carrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return list
     */
    public List<CarrierType> getCarrierList() {
        return carrierList;
    }

    /** 
     * Set the list of 'Carrier' element items. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param list
     */
    public void setCarrierList(List<CarrierType> list) {
        carrierList = list;
    }

    /** 
     * Get the 'Name' element value. Alliance name. Example: One World Alliance
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Alliance name. Example: One World Alliance
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'URL' element value. Alliance information URL. Example: http://www.oneworld.com/home
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Alliance information URL. Example: http://www.oneworld.com/home
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }
}
