
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Enumeration values for Bag Disclosure Rule Type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BagDisclosureRuleTypeCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="D"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Y"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum BagDisclosureRuleTypeCodeContentType implements Serializable {
    /** 
     * Disclosure with no US DOT Reservation
     */
    D("D"), /** 
             * No Disclosure or US DOT Reservation
             */
    N("N"), /** 
             * Other
             */
    OTHER("Other"), /** 
                     * Disclosure and US DOT Reservation
                     */
    Y("Y");
    private final String value;

    private BagDisclosureRuleTypeCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static BagDisclosureRuleTypeCodeContentType convert(String value) {
        for (BagDisclosureRuleTypeCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
