
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage service information used for long sells.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BagItemDetailsType" name="BagItemDetails" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrierCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageItemType implements Serializable
{
    private List<BagItemDetailsType> bagItemDetailList = new ArrayList<BagItemDetailsType>();
    private PriceType price;
    private String validatingCarrierCode;

    /** 
     * Get the list of 'BagItemDetails' element items. Additional disclosure and allowance information for Bag Items used in Long Sells.
     * 
     * @return list
     */
    public List<BagItemDetailsType> getBagItemDetailList() {
        return bagItemDetailList;
    }

    /** 
     * Set the list of 'BagItemDetails' element items. Additional disclosure and allowance information for Bag Items used in Long Sells.
     * 
     * @param list
     */
    public void setBagItemDetailList(List<BagItemDetailsType> list) {
        bagItemDetailList = list;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'ValidatingCarrierCode' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA  Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @return value
     */
    public String getValidatingCarrierCode() {
        return validatingCarrierCode;
    }

    /** 
     * Set the 'ValidatingCarrierCode' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA  Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @param validatingCarrierCode
     */
    public void setValidatingCarrierCode(String validatingCarrierCode) {
        this.validatingCarrierCode = validatingCarrierCode;
    }
}
