
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Information related to a booking or reservation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingEntityType" name="BookingEntity" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BookingID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BookingRefTypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BookingRefType implements Serializable
{
    private BookingEntityType bookingEntity;
    private String bookingID;
    private String bookingRefTypeCode;

    /** 
     * Get the 'BookingEntity' element value. Airline or Organization assigning the booking information.
     * 
     * @return value
     */
    public BookingEntityType getBookingEntity() {
        return bookingEntity;
    }

    /** 
     * Set the 'BookingEntity' element value. Airline or Organization assigning the booking information.
     * 
     * @param bookingEntity
     */
    public void setBookingEntity(BookingEntityType bookingEntity) {
        this.bookingEntity = bookingEntity;
    }

    /** 
     * Get the 'BookingID' element value. Existing booking reference Identifier.
     * 
     * @return value
     */
    public String getBookingID() {
        return bookingID;
    }

    /** 
     * Set the 'BookingID' element value. Existing booking reference Identifier.
     * 
     * @param bookingID
     */
    public void setBookingID(String bookingID) {
        this.bookingID = bookingID;
    }

    /** 
     * Get the 'BookingRefTypeCode' element value. Booking Reference Type. Example: 6 (Passenger confirmation number) Encoding Scheme: IATA Padis Codeset - List for data element [1153] Reference Qualifier
     * 
     * @return value
     */
    public String getBookingRefTypeCode() {
        return bookingRefTypeCode;
    }

    /** 
     * Set the 'BookingRefTypeCode' element value. Booking Reference Type. Example: 6 (Passenger confirmation number) Encoding Scheme: IATA Padis Codeset - List for data element [1153] Reference Qualifier
     * 
     * @param bookingRefTypeCode
     */
    public void setBookingRefTypeCode(String bookingRefTypeCode) {
        this.bookingRefTypeCode = bookingRefTypeCode;
    }
}
