
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AirlineDesigCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="DuplicateDesigInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierType implements Serializable
{
    private String airlineDesigCode;
    private Boolean duplicateDesigInd;
    private String name;

    /** 
     * Get the 'AirlineDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getAirlineDesigCode() {
        return airlineDesigCode;
    }

    /** 
     * Set the 'AirlineDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param airlineDesigCode
     */
    public void setAirlineDesigCode(String airlineDesigCode) {
        this.airlineDesigCode = airlineDesigCode;
    }

    /** 
     * Get the 'DuplicateDesigInd' element value. Indicates that the IATA Airline Designator is a duplicate code shared by multiple airlines. To identify the airline - in this case - its name must be specified in addition to the designator.
     * 
     * @return value
     */
    public Boolean getDuplicateDesigInd() {
        return duplicateDesigInd;
    }

    /** 
     * Set the 'DuplicateDesigInd' element value. Indicates that the IATA Airline Designator is a duplicate code shared by multiple airlines. To identify the airline - in this case - its name must be specified in addition to the designator.
     * 
     * @param duplicateDesigInd
     */
    public void setDuplicateDesigInd(Boolean duplicateDesigInd) {
        this.duplicateDesigInd = duplicateDesigInd;
    }

    /** 
     * Get the 'Name' element value. Commercial name of the carrier.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Commercial name of the carrier.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
