
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Currency related parameters intended to influence which currency the shopping results are displayed in.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurParameterType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurAppCodeContentType" name="AppCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="DecimalsAllowedNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurParameterType implements Serializable
{
    private CurAppCodeContentType appCode;
    private String curCode;
    private BigDecimal decimalsAllowedNumber;
    private String name;

    /** 
     * Get the 'AppCode' element value. Currency code application.  Examples: Actual, Display, Requested, Conversion, Other
     * 
     * @return value
     */
    public CurAppCodeContentType getAppCode() {
        return appCode;
    }

    /** 
     * Set the 'AppCode' element value. Currency code application.  Examples: Actual, Display, Requested, Conversion, Other
     * 
     * @param appCode
     */
    public void setAppCode(CurAppCodeContentType appCode) {
        this.appCode = appCode;
    }

    /** 
     * Get the 'CurCode' element value. Currency Code as per ISO 4217.
     * 
     * @return value
     */
    public String getCurCode() {
        return curCode;
    }

    /** 
     * Set the 'CurCode' element value. Currency Code as per ISO 4217.
     * 
     * @param curCode
     */
    public void setCurCode(String curCode) {
        this.curCode = curCode;
    }

    /** 
     * Get the 'DecimalsAllowedNumber' element value. Specifies how many numbers to be specified after the decimal in case of currency amounts.
     * 
     * @return value
     */
    public BigDecimal getDecimalsAllowedNumber() {
        return decimalsAllowedNumber;
    }

    /** 
     * Set the 'DecimalsAllowedNumber' element value. Specifies how many numbers to be specified after the decimal in case of currency amounts.
     * 
     * @param decimalsAllowedNumber
     */
    public void setDecimalsAllowedNumber(BigDecimal decimalsAllowedNumber) {
        this.decimalsAllowedNumber = decimalsAllowedNumber;
    }

    /** 
     * Get the 'Name' element value. Currency name, e.g. US Dollars.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Currency name, e.g. US Dollars.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }
}
