
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Function to accept the deletion of an OrderItem from the existing Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteOrderItemType implements Serializable
{
    private List<String> orderItemRefIDList = new ArrayList<String>();

    /** 
     * Get the list of 'OrderItemRefID' element items. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @return list
     */
    public List<String> getOrderItemRefIDList() {
        return orderItemRefIDList;
    }

    /** 
     * Set the list of 'OrderItemRefID' element items. Carrier assigned ID which exists uniquely within an Order.
     * 
     * @param list
     */
    public void setOrderItemRefIDList(List<String> list) {
        orderItemRefIDList = list;
    }
}
