
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Device upon which the secure transaction will occur.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeviceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BrowserAcceptHeaderText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BrowserUserAgentHeaderText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DeviceCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DeviceName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:GeospatialLocationType" name="GeospatialLocation" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IPAddressText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MAC_Address" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PhoneType" name="Phone" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TouchPointTrxCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeviceType implements Serializable
{
    private String browserAcceptHeaderText;
    private String browserUserAgentHeaderText;
    private String deviceCode;
    private String deviceName;
    private GeospatialLocationType geospatialLocation;
    private String IPAddressText;
    private String MACAddress;
    private PhoneType phone;
    private String touchPointTrxCode;

    /** 
     * Get the 'BrowserAcceptHeaderText' element value. Browser Accept Header. Note: This contains MIME types accepted by the device.
     * 
     * @return value
     */
    public String getBrowserAcceptHeaderText() {
        return browserAcceptHeaderText;
    }

    /** 
     * Set the 'BrowserAcceptHeaderText' element value. Browser Accept Header. Note: This contains MIME types accepted by the device.
     * 
     * @param browserAcceptHeaderText
     */
    public void setBrowserAcceptHeaderText(String browserAcceptHeaderText) {
        this.browserAcceptHeaderText = browserAcceptHeaderText;
    }

    /** 
     * Get the 'BrowserUserAgentHeaderText' element value. User Agent String. Note: This contains the user agent string.
     * 
     * @return value
     */
    public String getBrowserUserAgentHeaderText() {
        return browserUserAgentHeaderText;
    }

    /** 
     * Set the 'BrowserUserAgentHeaderText' element value. User Agent String. Note: This contains the user agent string.
     * 
     * @param browserUserAgentHeaderText
     */
    public void setBrowserUserAgentHeaderText(String browserUserAgentHeaderText) {
        this.browserUserAgentHeaderText = browserUserAgentHeaderText;
    }

    /** 
     * Get the 'DeviceCode' element value. The device code from which the request was initiated.
     * 
     * @return value
     */
    public String getDeviceCode() {
        return deviceCode;
    }

    /** 
     * Set the 'DeviceCode' element value. The device code from which the request was initiated.
     * 
     * @param deviceCode
     */
    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }

    /** 
     * Get the 'DeviceName' element value. Named Device ID.  Example: Johns IPAD
     * 
     * @return value
     */
    public String getDeviceName() {
        return deviceName;
    }

    /** 
     * Set the 'DeviceName' element value. Named Device ID.  Example: Johns IPAD
     * 
     * @param deviceName
     */
    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    /** 
     * Get the 'GeospatialLocation' element value. A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * 
     * @return value
     */
    public GeospatialLocationType getGeospatialLocation() {
        return geospatialLocation;
    }

    /** 
     * Set the 'GeospatialLocation' element value. A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
     * 
     * @param geospatialLocation
     */
    public void setGeospatialLocation(GeospatialLocationType geospatialLocation) {
        this.geospatialLocation = geospatialLocation;
    }

    /** 
     * Get the 'IPAddressText' element value. Associated IP address. Examples: 192.0.2.8, 198.51.100.0
     * 
     * @return value
     */
    public String getIPAddressText() {
        return IPAddressText;
    }

    /** 
     * Set the 'IPAddressText' element value. Associated IP address. Examples: 192.0.2.8, 198.51.100.0
     * 
     * @param IPAddressText
     */
    public void setIPAddressText(String IPAddressText) {
        this.IPAddressText = IPAddressText;
    }

    /** 
     * Get the 'MAC_Address' element value. Device MAC Address. Example: 00:0a:95:9d:68:16
     * 
     * @return value
     */
    public String getMACAddress() {
        return MACAddress;
    }

    /** 
     * Set the 'MAC_Address' element value. Device MAC Address. Example: 00:0a:95:9d:68:16
     * 
     * @param MACAddress
     */
    public void setMACAddress(String MACAddress) {
        this.MACAddress = MACAddress;
    }

    /** 
     * Get the 'Phone' element value. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * 
     * @return value
     */
    public PhoneType getPhone() {
        return phone;
    }

    /** 
     * Set the 'Phone' element value. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * 
     * @param phone
     */
    public void setPhone(PhoneType phone) {
        this.phone = phone;
    }

    /** 
     * Get the 'TouchPointTrxCode' element value. The travel event that triggered the request.  Example: Order/buy, Check-In, In Flight.  PADIS codeset TTT
     * 
     * @return value
     */
    public String getTouchPointTrxCode() {
        return touchPointTrxCode;
    }

    /** 
     * Set the 'TouchPointTrxCode' element value. The travel event that triggered the request.  Example: Order/buy, Check-In, In Flight.  PADIS codeset TTT
     * 
     * @param touchPointTrxCode
     */
    public void setTouchPointTrxCode(String touchPointTrxCode) {
        this.touchPointTrxCode = touchPointTrxCode;
    }
}
