
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage dimension allowance with application information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DimensionAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableBagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ApplicablePartyText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BaggageDimensionCategory" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:MeasureType" name="MaxMeasure" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="MinMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:QtyType" name="Qty" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DimensionAllowanceType implements Serializable
{
    private String applicableBagText;
    private String applicablePartyText;
    private String baggageDimensionCategory;
    private List<String> descTextList = new ArrayList<String>();
    private MeasureType maxMeasure;
    private MeasureType minMeasure;
    private QtyType qty;

    /** 
     * Get the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBagText() {
        return applicableBagText;
    }

    /** 
     * Set the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBagText
     */
    public void setApplicableBagText(String applicableBagText) {
        this.applicableBagText = applicableBagText;
    }

    /** 
     * Get the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicablePartyText() {
        return applicablePartyText;
    }

    /** 
     * Set the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @param applicablePartyText
     */
    public void setApplicablePartyText(String applicablePartyText) {
        this.applicablePartyText = applicablePartyText;
    }

    /** 
     * Get the 'BaggageDimensionCategory' element value. Baggage dimensions category. Examples: Length, Height, Width, Total Linear
     * 
     * @return value
     */
    public String getBaggageDimensionCategory() {
        return baggageDimensionCategory;
    }

    /** 
     * Set the 'BaggageDimensionCategory' element value. Baggage dimensions category. Examples: Length, Height, Width, Total Linear
     * 
     * @param baggageDimensionCategory
     */
    public void setBaggageDimensionCategory(String baggageDimensionCategory) {
        this.baggageDimensionCategory = baggageDimensionCategory;
    }

    /** 
     * Get the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @return list
     */
    public List<String> getDescTextList() {
        return descTextList;
    }

    /** 
     * Set the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @param list
     */
    public void setDescTextList(List<String> list) {
        descTextList = list;
    }

    /** 
     * Get the 'MaxMeasure' element value. Maximum dimensions value. Example: 62 Notes: Linear measurement = length + width + height
     * 
     * @return value
     */
    public MeasureType getMaxMeasure() {
        return maxMeasure;
    }

    /** 
     * Set the 'MaxMeasure' element value. Maximum dimensions value. Example: 62 Notes: Linear measurement = length + width + height
     * 
     * @param maxMeasure
     */
    public void setMaxMeasure(MeasureType maxMeasure) {
        this.maxMeasure = maxMeasure;
    }

    /** 
     * Get the 'MinMeasure' element value. Minimum dimensions value. Example: 62 Notes: Linear measurement = length + width + height
     * 
     * @return value
     */
    public MeasureType getMinMeasure() {
        return minMeasure;
    }

    /** 
     * Set the 'MinMeasure' element value. Minimum dimensions value. Example: 62 Notes: Linear measurement = length + width + height
     * 
     * @param minMeasure
     */
    public void setMinMeasure(MeasureType minMeasure) {
        this.minMeasure = minMeasure;
    }

    /** 
     * Get the 'Qty' element value. Quantity of pieces allowed with these measurements.
     * 
     * @return value
     */
    public QtyType getQty() {
        return qty;
    }

    /** 
     * Set the 'Qty' element value. Quantity of pieces allowed with these measurements.
     * 
     * @param qty
     */
    public void setQty(QtyType qty) {
        this.qty = qty;
    }
}
