
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The type of fair price applied to a Fare Detail (e.g. filed amount, net amount, or a sell amount).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FarePriceTypeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FarePriceTypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FarePriceTypeType implements Serializable
{
    private String farePriceTypeCode;
    private PriceType price;

    /** 
     * Get the 'FarePriceTypeCode' element value. Indicates if the fare price provided is a filed amount, net amount, or a sell amount.
     * 
     * @return value
     */
    public String getFarePriceTypeCode() {
        return farePriceTypeCode;
    }

    /** 
     * Set the 'FarePriceTypeCode' element value. Indicates if the fare price provided is a filed amount, net amount, or a sell amount.
     * 
     * @param farePriceTypeCode
     */
    public void setFarePriceTypeCode(String farePriceTypeCode) {
        this.farePriceTypeCode = farePriceTypeCode;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }
}
