
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight service information used for long sells.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FareDetailType" name="FareDetail" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginDestRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightItemType implements Serializable
{
    private FareDetailType fareDetail;
    private List<String> originDestRefIDList = new ArrayList<String>();
    private PriceType price;

    /** 
     * Get the 'FareDetail' element value. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @return value
     */
    public FareDetailType getFareDetail() {
        return fareDetail;
    }

    /** 
     * Set the 'FareDetail' element value. The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * 
     * @param fareDetail
     */
    public void setFareDetail(FareDetailType fareDetail) {
        this.fareDetail = fareDetail;
    }

    /** 
     * Get the list of 'OriginDestRefID' element items. Reference to an Origin Destination within this message.
     * 
     * @return list
     */
    public List<String> getOriginDestRefIDList() {
        return originDestRefIDList;
    }

    /** 
     * Set the list of 'OriginDestRefID' element items. Reference to an Origin Destination within this message.
     * 
     * @param list
     */
    public void setOriginDestRefIDList(List<String> list) {
        originDestRefIDList = list;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }
}
