
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The OrderChange/ OrderView transaction set requests modifications to an Order by specifying which order items to change and what to change them to. The updated view of the Order is returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderChangeRQ">
 *   &lt;xs:key name="ContactInfoIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:ContactInfoList/k:ContactInfo"/>
 *     &lt;xs:field xpath="k:ContactInfoID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Party/k:Participant/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef7">
 *     &lt;xs:selector xpath="./k:Party/k:Recipient/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef8">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:Aggregator/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef9">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:EnabledSystem/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef10">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:RetailPartner/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef11">
 *     &lt;xs:selector xpath="./k:Party/k:Sender/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef12">
 *     &lt;xs:selector xpath="./k:Request/k:BookingRef/k:BookingEntity/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="BaggageAllowanceIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:BaggageAllowanceList/k:BaggageAllowance"/>
 *     &lt;xs:field xpath="k:BaggageAllowanceID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:BaggageItem/k:BagItemDetails/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="BaggageDisclosureIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:BaggageDisclosureList/k:BaggageDisclosure"/>
 *     &lt;xs:field xpath="k:BaggageDisclosureID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:BaggageDisclosureIDKey" name="BaggageDisclosureIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:BaggageItem/k:BagItemDetails/k:BaggageDisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PenaltyIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PenaltyList/k:Penalty"/>
 *     &lt;xs:field xpath="k:PenaltyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:FlightItem/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxSegmentIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxSegmentList/k:PaxSegment"/>
 *     &lt;xs:field xpath="k:PaxSegmentID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:FlightItem/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PriceClassIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PriceClassList/k:PriceClass"/>
 *     &lt;xs:field xpath="k:PriceClassID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:FlightItem/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxList/k:Pax"/>
 *     &lt;xs:field xpath="k:PaxID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:FlightItem/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="OriginDestIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:OriginDestList/k:OriginDest"/>
 *     &lt;xs:field xpath="k:OriginDestID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:OriginDestIDKey" name="OriginDestIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:FlightItem/k:OriginDestRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="DatedOperatingLegIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxSegmentList/k:PaxSegment/k:DatedOperatingLeg"/>
 *     &lt;xs:field xpath="k:DatedOperatingLegID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:SeatItem/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:SeatItem/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="SeatProfileIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:SeatProfileList/k:SeatProfile"/>
 *     &lt;xs:field xpath="k:SeatProfileID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:CreateOrderItem/k:OfferItemType/k:SeatItem/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:SelectedOffer/k:SelectedOfferItem/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:DatedOperatingLegIDKey" name="DatedOperatingLegIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:SelectedOffer/k:SelectedOfferItem/k:SelectedALaCarteOfferItem/k:FlightAssociations/k:DatedOperatingLegRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdateOrderItem/k:AcceptOffer/k:SelectedOffer/k:SelectedOfferItem/k:SelectedALaCarteOfferItem/k:FlightAssociations/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef2">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdatePax/k:Current/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Request/k:ChangeOrder/k:UpdatePax/k:New/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PenaltyIDKey" name="PenaltyIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:FareRule/k:PenaltyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef3">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PriceClassIDKey" name="PriceClassIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:FareComponent/k:PriceClassRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:FareList/k:FareGroup/k:FareDetail/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="PaxJourneyIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxJourneyList/k:PaxJourney"/>
 *     &lt;xs:field xpath="k:PaxJourneyID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:PaxJourneyIDKey" name="PaxJourneyIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:OriginDestList/k:OriginDest/k:PaxJourneyRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxSegmentIDKey" name="PaxSegmentIDKeyRef4">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxJourneyList/k:PaxJourney/k:PaxSegmentRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef13">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxList/k:Pax/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef5">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxList/k:Pax/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="DisclosureIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:DisclosureList/k:Disclosure"/>
 *     &lt;xs:field xpath="k:DisclosureID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:DisclosureIDKey" name="DisclosureIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:PaxSegmentList/k:PaxSegment/k:OperatingCarrierInfo/k:DisclosureRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:BaggageAllowanceIDKey" name="BaggageAllowanceIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:BaggageAllowanceRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:SeatProfileIDKey" name="SeatProfileIDKeyRef1">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:SeatProfileRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:key name="ServiceDefinitionIDKey">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition"/>
 *     &lt;xs:field xpath="k:ServiceDefinitionID"/>
 *   &lt;/xs:key>
 *   &lt;xs:keyref refer="ns:ServiceDefinitionIDKey" name="ServiceDefinitionIDKeyRef">
 *     &lt;xs:selector xpath="./k:Request/k:DataLists/k:ServiceDefinitionList/k:ServiceDefinition/k:ServiceDefinitionAssociation/k:ServiceBundle/k:ServiceDefinitionRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef14">
 *     &lt;xs:selector xpath="./k:Request/k:OrderChangeParameters/k:RefundFOPPref/k:DirectBill/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef15">
 *     &lt;xs:selector xpath="./k:Request/k:PaxGroup/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef16">
 *     &lt;xs:selector xpath="./k:Request/k:PaymentInfo/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef17">
 *     &lt;xs:selector xpath="./k:Request/k:PaymentInfo/k:PaymentMethod/k:DirectBill/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:PaxIDKey" name="PaxIDKeyRef6">
 *     &lt;xs:selector xpath="./k:Request/k:PaymentInfo/k:Promotion/k:PaxRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef18">
 *     &lt;xs:selector xpath="./k:Request/k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:Org/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:keyref refer="ns:ContactInfoIDKey" name="ContactInfoIDKeyRef19">
 *     &lt;xs:selector xpath="./k:Request/k:PaymentInfo/k:Promotion/k:PromotionIssuer/k:TravelAgency/k:ContactInfoRefID"/>
 *     &lt;xs:field xpath="."/>
 *   &lt;/xs:keyref>
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="AugmentationPoint" minOccurs="0">
 *         &lt;!-- Reference to inner class AugmentationPoint -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PartyType" name="Party" minOccurs="1" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:POS_Type" name="POS" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:RequestType" name="Request" minOccurs="1" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderChangeRQ implements Serializable
{
    private AugmentationPoint augmentationPoint;
    private MessageDocType messageDoc;
    private PartyType party;
    private IATAPayloadStandardAttributesType payloadAttributes;
    private POSType POS;
    private RequestType request;

    /** 
     * Get the 'AugmentationPoint' element value.
     * 
     * @return value
     */
    public AugmentationPoint getAugmentationPoint() {
        return augmentationPoint;
    }

    /** 
     * Set the 'AugmentationPoint' element value.
     * 
     * @param augmentationPoint
     */
    public void setAugmentationPoint(AugmentationPoint augmentationPoint) {
        this.augmentationPoint = augmentationPoint;
    }

    /** 
     * Get the 'MessageDoc' element value. NDC Message Document information.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. NDC Message Document information.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'Party' element value. NDC Message/ Transaction Party(s) information.  Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @return value
     */
    public PartyType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value. NDC Message/ Transaction Party(s) information.  Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @param party
     */
    public void setParty(PartyType party) {
        this.party = party;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA standard payload attributes.
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA standard payload attributes.
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }

    /** 
     * Get the 'POS' element value. Point of Sale information.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of Sale information.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'Request' element value. Order Change Query.
     * 
     * @return value
     */
    public RequestType getRequest() {
        return request;
    }

    /** 
     * Set the 'Request' element value. Order Change Query.
     * 
     * @param request
     */
    public void setRequest(RequestType request) {
        this.request = request;
    }
    /** 
     * Implementer-Augmented Structure.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:ns1="http://xml.amadeus.com/QUQPCQ_03_1_1A" xmlns:ns2="http://xml.amadeus.com/QUQMDQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AugmentationPoint" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:choice>
     *       &lt;xs:element ref="ns1:Queue_PlacePNR"/>
     *       &lt;xs:element ref="ns2:Queue_RemoveItem"/>
     *     &lt;/xs:choice>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AugmentationPoint implements Serializable
    {
        private int augmentationPointSelect = -1;
        private static final int QUEUE_PLACE_PNR_CHOICE = 0;
        private static final int QUEUE_REMOVE_ITEM_CHOICE = 1;
        private QueuePlacePNR queuePlacePNR;
        private QueueRemoveItem queueRemoveItem;

        private void setAugmentationPointSelect(int choice) {
            if (augmentationPointSelect == -1) {
                augmentationPointSelect = choice;
            } else if (augmentationPointSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearAugmentationPointSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearAugmentationPointSelect() {
            augmentationPointSelect = -1;
        }

        /** 
         * Check if QueuePlacePNR is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQueuePlacePNR() {
            return augmentationPointSelect == QUEUE_PLACE_PNR_CHOICE;
        }

        /** 
         * Get the 'Queue_PlacePNR' element value.
         * 
         * @return value
         */
        public QueuePlacePNR getQueuePlacePNR() {
            return queuePlacePNR;
        }

        /** 
         * Set the 'Queue_PlacePNR' element value.
         * 
         * @param queuePlacePNR
         */
        public void setQueuePlacePNR(QueuePlacePNR queuePlacePNR) {
            setAugmentationPointSelect(QUEUE_PLACE_PNR_CHOICE);
            this.queuePlacePNR = queuePlacePNR;
        }

        /** 
         * Check if QueueRemoveItem is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifQueueRemoveItem() {
            return augmentationPointSelect == QUEUE_REMOVE_ITEM_CHOICE;
        }

        /** 
         * Get the 'Queue_RemoveItem' element value.
         * 
         * @return value
         */
        public QueueRemoveItem getQueueRemoveItem() {
            return queueRemoveItem;
        }

        /** 
         * Set the 'Queue_RemoveItem' element value.
         * 
         * @param queueRemoveItem
         */
        public void setQueueRemoveItem(QueueRemoveItem queueRemoveItem) {
            setAugmentationPointSelect(QUEUE_REMOVE_ITEM_CHOICE);
            this.queueRemoveItem = queueRemoveItem;
        }
    }
}
