
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * The IATA_PayloadStdAttributes defines the standard attributes that appear on the root element for all IATA payloads.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_PayloadStandardAttributesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AltLangID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CorrelationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="EchoTokenText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PrimaryLangID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="RetransmissionInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="SeqNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="Timestamp" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TrxID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TrxStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="VersionNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IATAPayloadStandardAttributesType implements Serializable
{
    private String altLangID;
    private String correlationID;
    private String echoTokenText;
    private String primaryLangID;
    private Boolean retransmissionInd;
    private BigDecimal seqNumber;
    private DateTimeType timestamp;
    private String trxID;
    private String trxStatusCode;
    private BigDecimal versionNumber;

    /** 
     * Get the 'AltLangID' element value. Identifies the alternate language for a customer or message. The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getAltLangID() {
        return altLangID;
    }

    /** 
     * Set the 'AltLangID' element value. Identifies the alternate language for a customer or message. The human language is identified by ISO 639 codes.
     * 
     * @param altLangID
     */
    public void setAltLangID(String altLangID) {
        this.altLangID = altLangID;
    }

    /** 
     * Get the 'CorrelationID' element value. Allow end-to-end correlation of log messages with the corresponding Web service message throughout the processing of the Web service message.
     * 
     * @return value
     */
    public String getCorrelationID() {
        return correlationID;
    }

    /** 
     * Set the 'CorrelationID' element value. Allow end-to-end correlation of log messages with the corresponding Web service message throughout the processing of the Web service message.
     * 
     * @param correlationID
     */
    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    /** 
     * Get the 'EchoTokenText' element value. A reference for additional message identification, assigned by the requesting host system. When a request message includes an echo token the corresponding response message MUST include an echo token with an identical value.
     * 
     * @return value
     */
    public String getEchoTokenText() {
        return echoTokenText;
    }

    /** 
     * Set the 'EchoTokenText' element value. A reference for additional message identification, assigned by the requesting host system. When a request message includes an echo token the corresponding response message MUST include an echo token with an identical value.
     * 
     * @param echoTokenText
     */
    public void setEchoTokenText(String echoTokenText) {
        this.echoTokenText = echoTokenText;
    }

    /** 
     * Get the 'PrimaryLangID' element value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @return value
     */
    public String getPrimaryLangID() {
        return primaryLangID;
    }

    /** 
     * Set the 'PrimaryLangID' element value. Identifes the primary language preference for the message.  The human language is identified by ISO 639 codes.
     * 
     * @param primaryLangID
     */
    public void setPrimaryLangID(String primaryLangID) {
        this.primaryLangID = primaryLangID;
    }

    /** 
     * Get the 'RetransmissionInd' element value. When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to true) only when a message is retransmitted.
     * 
     * @return value
     */
    public Boolean getRetransmissionInd() {
        return retransmissionInd;
    }

    /** 
     * Set the 'RetransmissionInd' element value. When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to true) only when a message is retransmitted.
     * 
     * @param retransmissionInd
     */
    public void setRetransmissionInd(Boolean retransmissionInd) {
        this.retransmissionInd = retransmissionInd;
    }

    /** 
     * Get the 'SeqNumber' element value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and needs to retrieve messages that were missed.
     * 
     * @return value
     */
    public BigDecimal getSeqNumber() {
        return seqNumber;
    }

    /** 
     * Set the 'SeqNumber' element value. Used to identify the sequence number of the transaction as assigned by the sending system; allows for an application to process messages in a certain order or to request a resynchronization of messages in the event that a system has been off-line and needs to retrieve messages that were missed.
     * 
     * @param seqNumber
     */
    public void setSeqNumber(BigDecimal seqNumber) {
        this.seqNumber = seqNumber;
    }

    /** 
     * Get the 'Timestamp' element value. Indicates the creation date and time of the message in UTC.
     * 
     * @return value
     */
    public DateTimeType getTimestamp() {
        return timestamp;
    }

    /** 
     * Set the 'Timestamp' element value. Indicates the creation date and time of the message in UTC.
     * 
     * @param timestamp
     */
    public void setTimestamp(DateTimeType timestamp) {
        this.timestamp = timestamp;
    }

    /** 
     * Get the 'TrxID' element value. A unique identifier to relate all messages within a transaction (e.g. this would be sent in all request and response messages that are part of an on-going transaction).
     * 
     * @return value
     */
    public String getTrxID() {
        return trxID;
    }

    /** 
     * Set the 'TrxID' element value. A unique identifier to relate all messages within a transaction (e.g. this would be sent in all request and response messages that are part of an on-going transaction).
     * 
     * @param trxID
     */
    public void setTrxID(String trxID) {
        this.trxID = trxID;
    }

    /** 
     * Get the 'TrxStatusCode' element value. This indicates where this message falls within a sequence of messages.
     * 
     * @return value
     */
    public String getTrxStatusCode() {
        return trxStatusCode;
    }

    /** 
     * Set the 'TrxStatusCode' element value. This indicates where this message falls within a sequence of messages.
     * 
     * @param trxStatusCode
     */
    public void setTrxStatusCode(String trxStatusCode) {
        this.trxStatusCode = trxStatusCode;
    }

    /** 
     * Get the 'VersionNumber' element value. For all IATA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @return value
     */
    public BigDecimal getVersionNumber() {
        return versionNumber;
    }

    /** 
     * Set the 'VersionNumber' element value. For all IATA versioned messages, the version of the message is indicated by a decimal value.
     * 
     * @param versionNumber
     */
    public void setVersionNumber(BigDecimal versionNumber) {
        this.versionNumber = versionNumber;
    }
}
