
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * A person or company that sells goods or services.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MerchantAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MerchantID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MerchantName" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class MerchantAccountType implements Serializable
{
    private CarrierType carrier;
    private CountryType country;
    private String merchantID;
    private String merchantName;

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'MerchantID' element value. identifier passed from the merchant (airline) to the PSP/Bank to identify themselves during the authorization transaction.
     * 
     * @return value
     */
    public String getMerchantID() {
        return merchantID;
    }

    /** 
     * Set the 'MerchantID' element value. identifier passed from the merchant (airline) to the PSP/Bank to identify themselves during the authorization transaction.
     * 
     * @param merchantID
     */
    public void setMerchantID(String merchantID) {
        this.merchantID = merchantID;
    }

    /** 
     * Get the 'MerchantName' element value. name under which the merchant is registered within their PSP/Bank
     * 
     * @return value
     */
    public String getMerchantName() {
        return merchantName;
    }

    /** 
     * Set the 'MerchantName' element value. name under which the merchant is registered within their PSP/Bank
     * 
     * @param merchantName
     */
    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }
}
